/*
 * Copyright (C) 1996 Emanuel Borsboom <manny@zerius.victoria.bc.ca>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package sound.zrs.synth;

import sound.zrs.synthgen.Distort;
import sound.zrs.synthgen.Synthesizer;
import sound.zrs.ui.PropertiesDialog;

class DistortBox extends GeneratorBox {
    static final String IDENT = "Dist";

    DistortBox(SynthComponent pa) {
        super(pa, IDENT);
        setLabel("Distort");
        addInput(new Input(this, "x"));
    }

    void newGenerator(Synthesizer synth) {
        synth.add(generator = new Distort(synth));
    }

    void connectGenerator(Synthesizer synth)
            throws SynthIfException {
        ((Distort) generator).setParameters(
                ((Input) inputs.elementAt(0)).getGenerator());
    }

    public PropertiesDialog getProperties() {
        return null;
    }
}


