package sound.filterDesign;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   TimeFrame.java

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

public class TimeFrame extends Frame
        implements ActionListener, ItemListener {

    public TimeFrame(TimeDomainBean timedomainbean) {
        super("Set Parameters");
        setSize(550, 200);
        setResizable(false);
        setVisible(false);
        timeDomain = timedomainbean;
        thick = 1;
        setLayout(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        xMin = new Label("Minimum time ", 2);
        xMax = new Label("Maximum time ", 2);
        yMin = new Label("Minimum  ", 2);
        yMax = new Label("Maximum  ", 2);
        precise = new Label("Precision (1-300)  ", 2);
        gain = new Label("Gain  ", 2);
        Label label = new Label("Thickness : ", 2);
        error =
                new Label(
                        "There are no errors for now but it could happen !!!",
                        1);
        minTime = new TextField(5);
        maxTime = new TextField(5);
        minimum = new TextField(5);
        maximum = new TextField(5);
        precision = new TextField(5);
        gainField = new TextField(5);
        epaisseur = new CheckboxGroup();
        t1 = new Checkbox(" 1 ", true, epaisseur);
        t2 = new Checkbox(" 2 ", false, epaisseur);
        okButton = new Button("OK");
        cancelButton = new Button("Cancel");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(3, 4));
        panel.add(xMin);
        panel.add(minTime);
        panel.add(xMax);
        panel.add(maxTime);
        panel.add(yMin);
        panel.add(minimum);
        panel.add(yMax);
        panel.add(maximum);
        panel.add(precise);
        panel.add(precision);
        panel.add(gain);
        panel.add(gainField);
        gridbagconstraints.gridy = 0;
        add(panel, gridbagconstraints);
        Panel panel1 = new Panel();
        panel1.add(okButton);
        panel1.add(cancelButton);
        Panel panel2 = new Panel();
        panel2.add(label);
        panel2.add(t1);
        panel2.add(t2);
        gridbagconstraints.gridy = 1;
        add(panel2, gridbagconstraints);
        gridbagconstraints.gridy = 2;
        add(error, gridbagconstraints);
        gridbagconstraints.gridy = 3;
        add(panel1, gridbagconstraints);
        validate();
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        minTime.addActionListener(this);
        maxTime.addActionListener(this);
        minimum.addActionListener(this);
        maximum.addActionListener(this);
        precision.addActionListener(this);
        gainField.addActionListener(this);
        t1.addItemListener(this);
        t2.addItemListener(this);
        addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent windowevent) {
                setVisible(false);
            }

        });
        error.setText("");
    }

    public void wake() {
        para = timeDomain.newParams();
        x1 = ((Double) para.elementAt(0)).doubleValue();
        x2 = ((Double) para.elementAt(1)).doubleValue();
        y1 = ((Double) para.elementAt(2)).doubleValue();
        y2 = ((Double) para.elementAt(3)).doubleValue();
        p = ((Integer) para.elementAt(4)).intValue();
        g = ((Double) para.elementAt(5)).doubleValue();
        minTime.setText(String.valueOf(x1));
        maxTime.setText(String.valueOf(x2));
        minimum.setText(String.valueOf(y1));
        maximum.setText(String.valueOf(y2));
        precision.setText(String.valueOf(p));
        gainField.setText(String.valueOf(g));
        error.setText(
                "Still a big long enormous string, just because things are strange in this world");
        setVisible(true);
        error.setText("");
    }

    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj == cancelButton) {
            setVisible(false);
            return;
        }
        try {
            x1 = (new Double(minTime.getText())).doubleValue();
            x2 = (new Double(maxTime.getText())).doubleValue();
            y1 = (new Double(minimum.getText())).doubleValue();
            y2 = (new Double(maximum.getText())).doubleValue();
            p = (new Integer(precision.getText())).intValue();
            g = (new Double(gainField.getText())).doubleValue();
            if (x1 >= x2 ||
                    y1 >= y2 ||
                    p < 1 ||
                    p > 300 ||
                    x1 < 0.0D ||
                    x2 < 0.0D) {
                throw new MyException("Please, insert correct values !!!");
            } else {
                para = new Vector();
                para.addElement(new Double(x1));
                para.addElement(new Double(x2));
                para.addElement(new Double(y1));
                para.addElement(new Double(y2));
                para.addElement(new Integer(p));
                para.addElement(new Double(g));
                para.addElement(new Integer(thick));
                error.setText("");
                timeDomain.oldParams(para);
                setVisible(false);
                return;
            }
        } catch (MyException myexception) {
            error.setText(myexception.getMessage());
            return;
        } catch (NumberFormatException _ex) {
            error.setText(
                    "A number is something with digits (0..9), thanks.");
        }
    }

    public void itemStateChanged(ItemEvent itemevent) {
        if (t1.getState()) {
            thick = 1;
            return;
        } else {
            thick = 2;
            return;
        }
    }

    double x1;
    double x2;
    double y1;
    double y2;
    double g;
    int p;
    int thick;
    Label xMin;
    Label xMax;
    Label yMin;
    Label yMax;
    Label precise;
    Label gain;
    Label error;
    TextField minTime;
    TextField maxTime;
    TextField minimum;
    TextField maximum;
    TextField precision;
    TextField gainField;
    Button okButton;
    Button cancelButton;
    CheckboxGroup epaisseur;
    Checkbox t1;
    Checkbox t2;
    TimeDomainBean timeDomain;
    Vector para;
}
