package sound.filterDesign;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PlotCanvasBean.java

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;

public class PlotCanvasBean extends Canvas
        implements ItemListener,
                   BodeListener,
                   MouseListener,
                   MouseMotionListener,
                   ActionListener,
                   Serializable {

    public PlotCanvasBean() {
        magColor = Color.red;
        phaseColor = Color.blue;
        constant = Math.log(10D);
        myMouseListeners = new Vector();
        pcs = new PropertyChangeSupport(this);
        point = new Point();
        poles = new Vector();
        zeros = new Vector();
        inputFrame = new ParamFrame(this);
        autoMag = true;
        magScale = 1;
        phaseScale = 1;
        degree = false;
        grid = true;
        grid2 = true;
        pop = new PopupMenu();
        m6 = new CheckboxMenuItem("Grid", true);
        pop.add(m6);
        m8 = new CheckboxMenuItem("Grid vertical (log)", true);
        pop.add(m8);
        pop.add("-");
        m1 = new CheckboxMenuItem("Autoscale mag", true);
        pop.add(m1);
        m2 = new Menu("Plot organisation");
        m2_1 = new CheckboxMenuItem("Both, seperate", true);
        m2.add(m2_1);
        m2_2 = new CheckboxMenuItem("Both, together", false);
        m2.add(m2_2);
        m2_3 = new CheckboxMenuItem("Only magnitude", false);
        m2.add(m2_3);
        m2_4 = new CheckboxMenuItem("Only phase", false);
        m2.add(m2_4);
        pop.add(m2);
        m3 = new Menu("Phase scale");
        m3_1 = new CheckboxMenuItem("Autoscale", true);
        m3.add(m3_1);
        m3_2 = new CheckboxMenuItem("Between -pi and pi", false);
        m3.add(m3_2);
        m3_3 = new CheckboxMenuItem("User scale", false);
        m3.add(m3_3);
        pop.add(m3);
        m4 = new Menu("Magnitude");
        m4_1 = new CheckboxMenuItem("dB", true);
        m4.add(m4_1);
        m4_2 = new CheckboxMenuItem("Log Magnitude", false);
        m4.add(m4_2);
        m4_3 = new CheckboxMenuItem("Magnitude", false);
        m4.add(m4_3);
        pop.add(m4);
        m5 = new Menu("Phase");
        m5_1 = new CheckboxMenuItem("Radians", true);
        m5.add(m5_1);
        m5_2 = new CheckboxMenuItem("Degrees", false);
        m5.add(m5_2);
        pop.add(m5);
        pop.add("-");
        m7 = new MenuItem("Set Parameters");
        pop.add(m7);
        add(pop);
        addMouseListener(this);
        addMouseMotionListener(this);
        m1.addItemListener(this);
        m2_1.addItemListener(this);
        m2_2.addItemListener(this);
        m2_3.addItemListener(this);
        m2_4.addItemListener(this);
        m3_1.addItemListener(this);
        m3_2.addItemListener(this);
        m3_3.addItemListener(this);
        m4_1.addItemListener(this);
        m4_2.addItemListener(this);
        m4_3.addItemListener(this);
        m5_1.addItemListener(this);
        m5_2.addItemListener(this);
        m6.addItemListener(this);
        m7.addActionListener(this);
        m8.addItemListener(this);
        setBackground(Color.white);
        setForeground(Color.black);
        setCursor(new Cursor(1));
        resultMag = new Vector();
        resultPhase = new Vector();
        precision = 10;
        state = 1;
        xMin = yMinMag = yMinPhase = 0.10000000000000001D;
        xMax = yMaxMag = yMaxPhase = 10D;
        K = 1.0D;
        logK = 0.0D;
        angleK = 0.0D;
        scale = log(xMax) - log(xMin);
        scale2 = log(yMaxMag) - log(yMinMag);
        dW = dH = 40;
        numberDecade();
    }

    public synchronized void paint(Graphics g) {
        update(g);
    }

    public synchronized void update(Graphics g) {
        Dimension dimension = getSize();
        if (offGraphics == null ||
                dimension.width != offDimension.width ||
                dimension.height != offDimension.height) {
            offDimension = dimension;
            offImage = createImage(dimension.width, dimension.height);
            offGraphics = offImage.getGraphics();
        }
        width = getSize().width;
        height = getSize().height;
        offGraphics.setColor(getBackground());
        offGraphics.fillRect(0,
                0,
                offDimension.width,
                offDimension.height);
        calculate(resultMag, resultPhase);
        if (magScale == 2)
            numberDecade();
        offGraphics.setColor(getForeground());
        offGraphics.drawRect(0, 0, width - 1, height - 1);
        if (grid)
            gridOn(offGraphics);
        if (magScale == 2 && grid2)
            gridOn2(offGraphics);
        paintMe(offGraphics);
        g.drawImage(offImage, 0, 0, this);
    }

    public void calculate(Vector vector, Vector vector1) {
        vector.removeAllElements();
        vector1.removeAllElements();
        double d5 = xMin;
        double d4;
        double d = d4 = 1.0D;
        double d2 = 0.0D;
        for (int j = 0; j < zeros.size(); j++) {
            Zero zero = new Zero((Zero) zeros.elementAt(j));
            d *= zero.absWrtOmega(xMin);
            d2 += zero.angleWrtOmega(xMin);
            if (zero.getImag() != 0.0D) {
                zero.setImag(-zero.getImag());
                d *= zero.absWrtOmega(xMin);
                d2 += zero.angleWrtOmega(xMin);
            }
        }

        for (int k = 0; k < poles.size(); k++) {
            Pole pole = new Pole((Pole) poles.elementAt(k));
            d /= pole.absWrtOmega(xMin);
            d2 -= pole.angleWrtOmega(xMin);
            if (pole.getImag() != 0.0D) {
                pole.setImag(-pole.getImag());
                d /= pole.absWrtOmega(xMin);
                d2 -= pole.angleWrtOmega(xMin);
            }
        }

        switch (magScale) {
            case 1: // '\001'
                d4 = 20D * logK + 10D * log(d);
                break;

            case 2: // '\002'
            case 3: // '\003'
                d4 = Math.abs(K) * Math.sqrt(d);
                break;
        }
        if (autoMag)
            yMinMag = yMaxMag = d4;
        if (phaseScale == 1) {
            yMinPhase = yMaxPhase = d2;
        } else {
            if (d2 < -3.1415926535897931D)
                for (;
                     d2 > 3.1415926535897931D &&
                        d2 < -3.1415926535897931D;
                     d2 += 6.2831853071795862D) ;
            if (d2 > 3.1415926535897931D)
                for (;
                     d2 > 3.1415926535897931D &&
                        d2 < -3.1415926535897931D;
                     d2 -= 6.2831853071795862D) ;
        }
        vector.addElement(new Double(d4));
        vector1.addElement(new Double(d2));
        for (int i = precision;
             i <= width - (state != 2 ? dW : 2 * dW);
             i += precision) {
            double d6 = xMin *
                    Math.pow(10D,
                            (scale * (double) i) /
                    (double) (width - (state != 2 ? dW : 2 * dW)));
            double d1 = 1.0D;
            double d3 = 0.0D;
            for (int l = 0; l < zeros.size(); l++) {
                Zero zero1 = new Zero((Zero) zeros.elementAt(l));
                d1 *= zero1.absWrtOmega(d6);
                d3 += zero1.angleWrtOmega(d6);
                if (zero1.getImag() != 0.0D) {
                    zero1.setImag(-zero1.getImag());
                    d1 *= zero1.absWrtOmega(d6);
                    d3 += zero1.angleWrtOmega(d6);
                }
            }

            for (int i1 = 0; i1 < poles.size(); i1++) {
                Pole pole1 = new Pole((Pole) poles.elementAt(i1));
                d1 /= pole1.absWrtOmega(d6);
                d3 -= pole1.angleWrtOmega(d6);
                if (pole1.getImag() != 0.0D) {
                    pole1.setImag(-pole1.getImag());
                    d1 /= pole1.absWrtOmega(d6);
                    d3 -= pole1.angleWrtOmega(d6);
                }
            }

            switch (magScale) {
                case 1: // '\001'
                    d4 = 20D * logK + 10D * log(d1);
                    break;

                case 2: // '\002'
                case 3: // '\003'
                    d4 = Math.abs(K) * Math.sqrt(d1);
                    break;
            }
            if (autoMag) {
                if (yMinMag > d4)
                    yMinMag = d4;
                if (yMaxMag < d4)
                    yMaxMag = d4;
            }
            if (phaseScale == 1) {
                if (yMinPhase > d3)
                    yMinPhase = d3;
                if (yMaxPhase < d3)
                    yMaxPhase = d3;
            }
            vector.addElement(new Double(d4));
            if (phaseScale > 1) {
                for (;
                     d3 < -3.1415926535897931D;
                     d3 += 6.2831853071795862D) ;
                for (;
                     d3 > 3.1415926535897931D;
                     d3 -= 6.2831853071795862D) ;
            }
            vector1.addElement(new Double(d3));
        }

        if (yMaxMag - yMinMag < 9.9999999999999994E-12D) {
            yMinMag = yMinMag - 1.0D;
            yMaxMag = yMaxMag + 1.0D;
        }
        if (phaseScale == 1 &&
                yMaxPhase - yMinPhase < 9.9999999999999994E-12D) {
            yMinPhase = yMinPhase - 1.5707963267948966D;
            yMaxPhase = yMaxPhase + 1.5707963267948966D;
        }
        if (phaseScale == 2) {
            yMinPhase = -3.1415926535897931D;
            yMaxPhase = 3.1415926535897931D;
        }
        if (magScale == 2 && yMinMag < 0.0D)
            yMinMag = yMaxMag / 10D;
    }

    public void paintMe(Graphics g) {
        int i = dW;
        switch (state) {
            case 1: // '\001'
                drawAxes(g);
                int j;
                if (magScale == 2)
                    j =
                            (1 + height / 2) -
                            dH -
                            (int) Math.rint(
                                    (log(
                                            ((Double) resultMag.elementAt(
                                                    0)).doubleValue() /
                            yMinMag) *
                            (double) (height / 2 - dH)) /
                            (double) decade2);
                else
                    j = (height / 2 -
                            (int) Math.rint(
                                    ((((Double) resultMag.elementAt(0)).doubleValue() -
                            yMinMag) *
                            (double) (height / 2 - dH)) /
                            (yMaxMag - yMinMag)) -
                            dH) +
                            1;
                int i1 = (height -
                        (int) Math.rint(
                                ((((Double) resultPhase.elementAt(0)).doubleValue() -
                        yMinPhase) *
                        (double) (height / 2 - dH)) /
                        (yMaxPhase - yMinPhase)) -
                        dH) +
                        1;
                for (int j4 = 1; j4 < resultMag.size(); j4++) {
                    int l1 = i + precision;
                    int l2;
                    if (magScale == 2)
                        l2 =
                                (1 + height / 2) -
                                dH -
                                (int) Math.rint(
                                        (log(
                                                ((Double) resultMag.elementAt(
                                                        j4)).doubleValue() /
                                yMinMag) *
                                (double) (height / 2 - dH)) /
                                (double) decade2);
                    else
                        l2 = (height / 2 -
                                (int) Math.rint(
                                        ((((Double) resultMag.elementAt(
                                                j4)).doubleValue() -
                                yMinMag) *
                                (double) (height / 2 - dH)) /
                                (yMaxMag - yMinMag)) -
                                dH) +
                                1;
                    int k3 = (height -
                            (int) Math.rint(
                                    ((((Double) resultPhase.elementAt(j4)).doubleValue() -
                            yMinPhase) *
                            (double) (height / 2 - dH)) /
                            (yMaxPhase - yMinPhase)) -
                            dH) +
                            1;
                    if (l2 > (height / 2 - dH) + 2)
                        l2 = height / 2 - dH;
                    g.setColor(magColor);
                    g.drawLine(i, j, l1, l2);
                    if (k3 > (height - dH) + 2)
                        k3 = height - dH;
                    if (k3 < height / 2 - 2)
                        k3 = height / 2 - 2;
                    g.setColor(phaseColor);
                    g.drawLine(i, i1, l1, k3);
                    i = l1;
                    j = l2;
                    i1 = k3;
                }

                return;

            case 2: // '\002'
                drawAxes(g);
                int k;
                if (magScale == 2)
                    k =
                            (1 + height) -
                            dH -
                            (int) Math.rint(
                                    (log(
                                            ((Double) resultMag.elementAt(
                                                    0)).doubleValue() /
                            yMinMag) *
                            (double) (height - dH)) /
                            (double) decade2);
                else
                    k = (height -
                            (int) Math.rint(
                                    ((((Double) resultMag.elementAt(0)).doubleValue() -
                            yMinMag) *
                            (double) (height - dH)) /
                            (yMaxMag - yMinMag)) -
                            dH) +
                            1;
                int j1 = (height -
                        (int) Math.rint(
                                ((((Double) resultPhase.elementAt(0)).doubleValue() -
                        yMinPhase) *
                        (double) (height - dH)) /
                        (yMaxPhase - yMinPhase)) -
                        dH) +
                        1;
                for (int k4 = 1; k4 < resultMag.size(); k4++) {
                    int i2 = i + precision;
                    int i3;
                    if (magScale == 2)
                        i3 =
                                (1 + height) -
                                dH -
                                (int) Math.rint(
                                        (log(
                                                ((Double) resultMag.elementAt(
                                                        k4)).doubleValue() /
                                yMinMag) *
                                (double) (height - dH)) /
                                (double) decade2);
                    else
                        i3 = (height -
                                (int) Math.rint(
                                        ((((Double) resultMag.elementAt(
                                                k4)).doubleValue() -
                                yMinMag) *
                                (double) (height - dH)) /
                                (yMaxMag - yMinMag)) -
                                dH) +
                                1;
                    int l3 = (height -
                            (int) Math.rint(
                                    ((((Double) resultPhase.elementAt(k4)).doubleValue() -
                            yMinPhase) *
                            (double) (height - dH)) /
                            (yMaxPhase - yMinPhase)) -
                            dH) +
                            1;
                    if (i3 > (height - dH) + 2)
                        i3 = (height - dH) + 2;
                    g.setColor(magColor);
                    g.drawLine(i, k, i2, i3);
                    if (l3 > (height - dH) + 2)
                        l3 = height - dH;
                    g.setColor(phaseColor);
                    g.drawLine(i, j1, i2, l3);
                    i = i2;
                    k = i3;
                    j1 = l3;
                }

                return;

            case 3: // '\003'
                drawAxes(g);
                int l;
                if (magScale == 2)
                    l =
                            (1 + height) -
                            dH -
                            (int) Math.rint(
                                    (log(
                                            ((Double) resultMag.elementAt(
                                                    0)).doubleValue() /
                            yMinMag) *
                            (double) (height - dH)) /
                            (double) decade2);
                else
                    l = (height -
                            (int) Math.rint(
                                    ((((Double) resultMag.elementAt(0)).doubleValue() -
                            yMinMag) *
                            (double) (height - dH)) /
                            (yMaxMag - yMinMag)) -
                            dH) +
                            1;
                for (int l4 = 1; l4 < resultMag.size(); l4++) {
                    int j2 = i + precision;
                    int j3;
                    if (magScale == 2)
                        j3 =
                                (1 + height) -
                                dH -
                                (int) Math.rint(
                                        (log(
                                                ((Double) resultMag.elementAt(
                                                        l4)).doubleValue() /
                                yMinMag) *
                                (double) (height - dH)) /
                                (double) decade2);
                    else
                        j3 = (height -
                                (int) Math.rint(
                                        ((((Double) resultMag.elementAt(
                                                l4)).doubleValue() -
                                yMinMag) *
                                (double) (height - dH)) /
                                (yMaxMag - yMinMag)) -
                                dH) +
                                1;
                    if (j3 > (height - dH) + 2)
                        j3 = height - dH;
                    g.setColor(magColor);
                    g.drawLine(i, l, j2, j3);
                    i = j2;
                    l = j3;
                }

                return;

            case 4: // '\004'
                drawAxes(g);
                int k1 = (height -
                        (int) Math.rint(
                                ((((Double) resultPhase.elementAt(0)).doubleValue() -
                        yMinPhase) *
                        (double) (height - dH)) /
                        (yMaxPhase - yMinPhase)) -
                        dH) +
                        1;
                for (int i5 = 1; i5 < resultPhase.size(); i5++) {
                    int k2 = i + precision;
                    int i4 = (height -
                            (int) Math.rint(
                                    ((((Double) resultPhase.elementAt(i5)).doubleValue() -
                            yMinPhase) *
                            (double) (height - dH)) /
                            (yMaxPhase - yMinPhase)) -
                            dH) +
                            1;
                    if (i4 > (height - dH) + 2)
                        i4 = height - dH;
                    g.setColor(phaseColor);
                    g.drawLine(i, k1, k2, i4);
                    i = k2;
                    k1 = i4;
                }

                return;
        }
    }

    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj == m7)
            inputFrame.wake();
    }

    public void itemStateChanged(ItemEvent itemevent) {
        Object obj = itemevent.getSource();
        if (obj == m6) {
            gridon(m6.getState());
            return;
        }
        if (obj == m7) {
            gridon2(m8.getState());
            return;
        }
        if (obj == m1) {
            setAutoMag(m1.getState());
            return;
        }
        if (obj == m2_1) {
            m2_1.setState(true);
            m2_2.setState(false);
            m2_3.setState(false);
            m2_4.setState(false);
            setState(1);
            return;
        }
        if (obj == m2_2) {
            m2_2.setState(true);
            m2_1.setState(false);
            m2_3.setState(false);
            m2_4.setState(false);
            setState(2);
            return;
        }
        if (obj == m2_3) {
            m2_3.setState(true);
            m2_2.setState(false);
            m2_1.setState(false);
            m2_4.setState(false);
            setState(3);
            return;
        }
        if (obj == m2_4) {
            m2_4.setState(true);
            m2_2.setState(false);
            m2_3.setState(false);
            m2_1.setState(false);
            setState(4);
            return;
        }
        if (obj == m3_1) {
            m3_1.setState(true);
            m3_2.setState(false);
            m3_3.setState(false);
            setAutoPhase(1);
            return;
        }
        if (obj == m3_2) {
            m3_2.setState(true);
            m3_1.setState(false);
            m3_3.setState(false);
            setAutoPhase(2);
            return;
        }
        if (obj == m3_3) {
            m3_3.setState(true);
            m3_2.setState(false);
            m3_1.setState(false);
            setAutoPhase(3);
            return;
        }
        if (obj == m4_1) {
            m4_1.setState(true);
            m4_2.setState(false);
            m4_3.setState(false);
            setMagScale(1);
            return;
        }
        if (obj == m4_2) {
            m4_2.setState(true);
            m4_1.setState(false);
            m4_3.setState(false);
            setMagScale(2);
            return;
        }
        if (obj == m4_3) {
            m4_3.setState(true);
            m4_1.setState(false);
            m4_2.setState(false);
            setMagScale(3);
            return;
        }
        if (obj == m5_1) {
            m5_1.setState(true);
            m5_2.setState(false);
            setPhaseScale(false);
            return;
        }
        if (obj == m5_2) {
            m5_2.setState(true);
            m5_1.setState(false);
            setPhaseScale(true);
        }
    }

    public void changeOccured(BodeEvent bodeevent) {
        if (bodeevent.getSource() != this) {
            switch (bodeevent.getType()) {
                default:
                    break;

                case 0: // '\0'
                    poles.addElement(new Pole((Pole) bodeevent.getRoot()));
                    break;

                case 1: // '\001'
                    zeros.addElement(new Zero((Zero) bodeevent.getRoot()));
                    break;

                case 2: // '\002'
                    ((Pole) poles.elementAt(bodeevent.getPosition())).setPos(
                            bodeevent.getRoot().getReal(),
                            bodeevent.getRoot().getImag());
                    break;

                case 3: // '\003'
                    ((Zero) zeros.elementAt(bodeevent.getPosition())).setPos(
                            bodeevent.getRoot().getReal(),
                            bodeevent.getRoot().getImag());
                    break;

                case 4: // '\004'
                    poles.removeElementAt(bodeevent.getPosition());
                    break;

                case 5: // '\005'
                    zeros.removeElementAt(bodeevent.getPosition());
                    break;

                case 6: // '\006'
                    zeros.removeAllElements();
                    poles.removeAllElements();
                    break;

                case 7: // '\007'
                    Vector vector = bodeevent.getPoles();
                    synchronized (this) {
                        if (vector != null) {
                            poles.removeAllElements();
                            for (int i = 0; i < vector.size(); i++)
                                poles.addElement(
                                        new Pole(
                                                (Pole) vector.elementAt(i)));

                        }
                    }
                    break;

                case 8: // '\b'
                    Vector vector1 = bodeevent.getZeros();
                    synchronized (this) {
                        if (vector1 != null) {
                            zeros.removeAllElements();
                            for (int j = 0; j < vector1.size(); j++)
                                zeros.addElement(
                                        new Zero(
                                                (Zero) vector1.elementAt(
                                                        j)));

                        }
                    }
                    break;

                case 9: // '\t'
                    Vector vector2 = bodeevent.getPoles();
                    Vector vector3 = bodeevent.getZeros();
                    synchronized (this) {
                        if (vector2 != null) {
                            poles.removeAllElements();
                            for (int k = 0; k < vector2.size(); k++)
                                poles.addElement(
                                        new Pole(
                                                (Pole) vector2.elementAt(
                                                        k)));

                        }
                        if (vector3 != null) {
                            zeros.removeAllElements();
                            for (int l = 0; l < vector3.size(); l++)
                                zeros.addElement(
                                        new Zero(
                                                (Zero) vector3.elementAt(
                                                        l)));

                        }
                    }
                    break;
            }
            repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
        fireMyMouseEvent(new MyMouseEvent(this, "Bode Plot", 0.0D, 0.0D));
    }

    public void mousePressed(MouseEvent mouseevent) {
        if ((mouseevent.getModifiers() & 4) == 4 ||
                mouseevent.isShiftDown())
            popup(mouseevent.getX(), mouseevent.getY());
    }

    public void mouseMoved(MouseEvent mouseevent) {
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        double d = 0.0D;
        double d5 = 0.0D;
        String s = "Bode Plot";
        switch (state) {
            case 1: // '\001'
                double d1;
                if (i > dW - 1) {
                    d1 =
                            xMin *
                            Math.pow(10D,
                                    (scale * (double) (i - dW)) /
                            (double) (width - dW - 1));
                    if (j < (height / 2 - dH) + 2) {
                        switch (magScale) {
                            case 1: // '\001'
                            case 3: // '\003'
                                d5 = (((double) ((height / 2 - dH) + 1) -
                                        (double) j) *
                                        (yMaxMag - yMinMag)) /
                                        (double) ((height / 2 - dH) + 1) +
                                        yMinMag;
                                break;

                            case 2: // '\002'
                                d5 =
                                        yMinMag *
                                        Math.pow(10D,
                                                (double) (decade2 *
                                        ((-j + height / 2) - dH)) /
                                        (double) (height / 2 - dH));
                                break;
                        }
                        s = "Magnitude";
                    } else if (j < (height - dH) + 2 &&
                            j > height / 2 - 1) {
                        d5 = (((double) (height / 2 - dH) -
                                ((double) j - (double) (height / 2) - 1.0D)) *
                                (yMaxPhase - yMinPhase)) /
                                (double) (height / 2 - dH) +
                                yMinPhase;
                        s = "Phase";
                    } else {
                        d1 = 0.0D;
                        d5 = 0.0D;
                    }
                } else {
                    d1 = 0.0D;
                    d5 = 0.0D;
                }
                fireMyMouseEvent(new MyMouseEvent(this, s, d1, d5));
                return;

            case 2: // '\002'
                double d2;
                if (i > dW - 1 &&
                        i < (width - dW) + 1 &&
                        j < (height - dH) + 1) {
                    d2 =
                            xMin *
                            Math.pow(10D,
                                    (scale * (double) (i - dW)) /
                            (double) (width - dW - 1));
                    switch (magScale) {
                        case 1: // '\001'
                        case 3: // '\003'
                            d5 = (((double) (height - dH) - (double) j) *
                                    (yMaxMag - yMinMag)) /
                                    (double) (height - dH) +
                                    yMinMag;
                            break;

                        case 2: // '\002'
                            d5 =
                                    yMinMag *
                                    Math.pow(10D,
                                            (double) (decade2 *
                                    ((-j + height) - dH)) /
                                    (double) (height - dH));
                            break;
                    }
                } else {
                    d2 = 0.0D;
                    d5 = 0.0D;
                }
                fireMyMouseEvent(
                        new MyMouseEvent(this, "Magnitude", d2, d5));
                return;

            case 3: // '\003'
                double d3;
                if (i > dW - 1 && j < (height - dH) + 1) {
                    d3 =
                            xMin *
                            Math.pow(10D,
                                    (scale * (double) (i - dW)) /
                            (double) (width - dW - 1));
                    switch (magScale) {
                        case 1: // '\001'
                        case 3: // '\003'
                            d5 = (((double) (height - dH) - (double) j) *
                                    (yMaxMag - yMinMag)) /
                                    (double) (height - dH) +
                                    yMinMag;
                            break;

                        case 2: // '\002'
                            d5 =
                                    yMinMag *
                                    Math.pow(10D,
                                            (double) (decade2 *
                                    ((-j + height) - dH)) /
                                    (double) (height - dH));
                            break;
                    }
                } else {
                    d3 = 0.0D;
                    d5 = 0.0D;
                }
                fireMyMouseEvent(
                        new MyMouseEvent(this, "Magnitude", d3, d5));
                return;

            case 4: // '\004'
                double d4;
                double d6;
                if (i > dW - 1 && j < (height - dH) + 1) {
                    d4 =
                            xMin *
                            Math.pow(10D,
                                    (scale * (double) (i - dW)) /
                            (double) (width - dW - 1));
                    d6 = (((double) (height - dH) - (double) j) *
                            (yMaxPhase - yMinPhase)) /
                            (double) (height - dH) +
                            yMinPhase;
                } else {
                    d4 = 0.0D;
                    d6 = 0.0D;
                }
                fireMyMouseEvent(new MyMouseEvent(this, "Phase", d4, d6));
                return;
        }
    }

    public void mouseDragged(MouseEvent mouseevent) {
    }

    public double log(double d) {
        return Math.log(d) / constant;
    }

    public void numberDecade() {
        decade = (int) Math.rint(Math.ceil(log(xMax) - log(xMin)));
        xMax = xMin * Math.pow(10D, decade);
        scale = log(xMax) - log(xMin);
        logK = log(K);
        angleK = K <= 0.0D ? 3.1415926535897931D : 0.0D;
        if (magScale == 2) {
            double d = yMinMag;
            if (d < 1.0D) {
                while ((d *= 10D) < 1.0D) ;
                yMinMag /= d;
            } else if (d > 10D) {
                while ((d /= 10D) > 10D) ;
                yMinMag /= d;
            } else {
                yMinMag /= yMinMag;
            }
            if ((new Double(yMaxMag)).isInfinite()) {
                decade2 = 1;
                yMaxMag = 10D;
                yMinMag = 1.0D;
                scale2 = 1.0D;
                return;
            }
            scale2 = log(yMaxMag) - log(yMinMag);
            decade2 = (int) Math.rint(Math.ceil(scale2));
            yMaxMag = yMinMag * Math.pow(10D, decade2);
        }
    }

    public void setState(int i) {
        state = i;
        repaint();
    }

    public void setAutoMag(boolean flag) {
        autoMag = flag;
        repaint();
    }

    public void setAutoPhase(int i) {
        phaseScale = i;
        repaint();
    }

    public void setPhaseScale(boolean flag) {
        degree = flag;
        repaint();
    }

    public void setMagScale(int i) {
        magScale = i;
        repaint();
    }

    public void popup(int i, int j) {
        pop.show(this, i, j);
    }

    public void gridon(boolean flag) {
        grid = flag;
        repaint();
    }

    public void gridon2(boolean flag) {
        grid2 = flag;
        repaint();
    }

    public void drawAxes(Graphics g) {
        switch (state) {
            case 1: // '\001'
                int i = dW;
                int i1 = width - 1;
                int i2 = 1;
                int i3 = (height / 2 - dH) + 1;
                g.drawLine(i, i2, i, i3);
                g.drawLine(i, i2, i - 3, i2 + 5);
                g.drawLine(i, i2, i + 3, i2 + 5);
                g.drawString(d2str(yMaxMag), 1, 10);
                g.drawString(d2str(yMinMag), 1, i3 + 5);
                g.drawLine(i, i3, i1, i3);
                g.drawLine(i1, i3, i1 - 5, i3 + 3);
                g.drawLine(i1, i3, i1 - 5, i3 - 3);
                g.drawString(d2str(xMin), dW - 5, i3 + 15);
                g.drawString(d2str(xMax), i1 - 35, i3 + 15);
                labelDecade(g, i3);
                i2 = height / 2 + 1;
                i3 = (height - dH) + 1;
                g.drawLine(i, i2, i, i3);
                g.drawLine(i, i2, i - 3, i2 + 5);
                g.drawLine(i, i2, i + 3, i2 + 5);
                g.drawString(
                        degree ?
                        String.valueOf(
                                (int) Math.rint(
                                        (180D * yMaxPhase) /
                        3.1415926535897931D)) :
                        d2str(yMaxPhase),
                        1,
                        i2 + 10);
                g.drawString(
                        degree ?
                        String.valueOf(
                                (int) Math.rint(
                                        (180D * yMinPhase) /
                        3.1415926535897931D)) :
                        d2str(yMinPhase),
                        1,
                        i3 + 5);
                g.drawLine(i, i3, i1, i3);
                g.drawLine(i1, i3, i1 - 5, i3 + 3);
                g.drawLine(i1, i3, i1 - 5, i3 - 3);
                g.drawString(d2str(xMin), dW - 5, i3 + 15);
                g.drawString(d2str(xMax), i1 - 35, i3 + 15);
                labelDecade(g, i3);
                return;

            case 2: // '\002'
                int j = dW;
                int j1 = width - dW;
                int j2 = 1;
                int j3 = height - dH;
                g.drawLine(j, j2, j, j3);
                g.drawLine(j, j2, j - 3, j2 + 5);
                g.drawLine(j, j2, j + 3, j2 + 5);
                g.drawString(d2str(yMaxMag), 1, 10);
                g.drawString(d2str(yMinMag), 1, j3 + 5);
                g.drawLine(j, j3, j1, j3);
                g.drawLine(j1, j3, j1 - 5, j3 + 3);
                g.drawLine(j1, j3, j1 - 5, j3 - 3);
                g.drawString(d2str(xMin), dW - 5, j3 + 15);
                g.drawString(d2str(xMax), j1 - 25, j3 + 15);
                g.drawLine(j1, j2, j1, j3);
                g.drawLine(j1, j2, j1 - 3, j2 + 5);
                g.drawLine(j1, j2, j1 + 3, j2 + 5);
                g.drawString(
                        degree ?
                        String.valueOf(
                                (int) Math.rint(
                                        (180D * yMaxPhase) /
                        3.1415926535897931D)) :
                        d2str(yMaxPhase),
                        j1 + 3,
                        10);
                g.drawString(
                        degree ?
                        String.valueOf(
                                (int) Math.rint(
                                        (180D * yMinPhase) /
                        3.1415926535897931D)) :
                        d2str(yMinPhase),
                        j1 + 3,
                        j3 + 5);
                labelDecade(g, j3);
                return;

            case 3: // '\003'
                int k = dW;
                int k1 = width;
                int k2 = 1;
                int k3 = height - dH;
                g.drawLine(k, k2, k, k3);
                g.drawLine(k, k2, k - 3, k2 + 5);
                g.drawLine(k, k2, k + 3, k2 + 5);
                g.drawString(d2str(yMaxMag), 1, 10);
                g.drawString(d2str(yMinMag), 1, k3 + 5);
                g.drawLine(k, k3, k1, k3);
                g.drawLine(k1, k3, k1 - 5, k3 + 3);
                g.drawLine(k1, k3, k1 - 5, k3 - 3);
                g.drawString(d2str(xMin), dW - 5, k3 + 15);
                g.drawString(d2str(xMax), k1 - 35, k3 + 15);
                labelDecade(g, k3);
                return;

            case 4: // '\004'
                int l = dW;
                int l1 = width;
                int l2 = 1;
                int l3 = height - dH;
                g.drawLine(l, l2, l, l3);
                g.drawLine(l, l2, l - 3, l2 + 5);
                g.drawLine(l, l2, l + 3, l2 + 5);
                g.drawString(
                        degree ?
                        String.valueOf(
                                (int) Math.rint(
                                        (180D * yMaxPhase) /
                        3.1415926535897931D)) :
                        d2str(yMaxPhase),
                        1,
                        10);
                g.drawString(
                        degree ?
                        String.valueOf(
                                (int) Math.rint(
                                        (180D * yMinPhase) /
                        3.1415926535897931D)) :
                        d2str(yMinPhase),
                        1,
                        l3 + 5);
                g.drawLine(l, l3, l1, l3);
                g.drawLine(l1, l3, l1 - 5, l3 + 3);
                g.drawLine(l1, l3, l1 - 5, l3 - 3);
                g.drawString(d2str(xMin), dW - 5, l3 + 15);
                g.drawString(d2str(xMax), l1 - 35, l3 + 15);
                labelDecade(g, l3);
                return;
        }
    }

    public void labelDecade(Graphics g, int i) {
        int k = width - (state != 2 ? dW : 2 * dW);
        for (double d = xMin * 10D; d < xMax; d *= 10D) {
            int j = dW + (int) ((log(d / xMin) * (double) k) / scale);
            g.drawLine(j, i - 3, j, i + 3);
            g.drawString(d2str(d), j - 15, i + 15);
        }

    }

    public void gridOn(Graphics g) {
        Color color = new Color(g.getColor().getRGB());
        g.setColor(Color.lightGray);
        int i = (width - (state != 2 ? dW : 2 * dW)) / decade;
        if (state == 1) {
            for (int j = 0; j < 10; j++) {
                int l = (int) Math.rint((double) dW + log(j) * (double) i);
                for (int j1 = 0; j1 < decade; j1++) {
                    g.drawLine(l + j1 * i,
                            height - 40,
                            l + j1 * i,
                            height / 2);
                    g.drawLine(l + j1 * i,
                            height / 2 - 40,
                            l + j1 * i,
                            1);
                }

            }

            g.setColor(color);
            return;
        }
        for (int k = 0; k < 10; k++) {
            int i1 = (int) Math.rint((double) dW + log(k) * (double) i);
            for (int k1 = 0; k1 < decade; k1++)
                g.drawLine(i1 + k1 * i, height - 40, i1 + k1 * i, 1);

        }

        g.setColor(color);
    }

    public void gridOn2(Graphics g) {
        Color color = new Color(g.getColor().getRGB());
        g.setColor(Color.lightGray);
        switch (state) {
            default:
                break;

            case 1: // '\001'
                int i = (height / 2 - dH) / decade2;
                for (int l = 1; l < 10; l++) {
                    int k1 = (int) Math.rint(log(l) * (double) i);
                    for (int j2 = 0; j2 < decade2; j2++)
                        g.drawLine(dW,
                                height / 2 - dH - k1 - j2 * i,
                                width,
                                height / 2 - dH - k1 - j2 * i);

                }

                break;

            case 2: // '\002'
                int j = (height - dH) / decade2;
                for (int i1 = 1; i1 < 10; i1++) {
                    int l1 = (int) Math.rint(log(i1) * (double) j);
                    for (int k2 = 0; k2 < decade2; k2++)
                        g.drawLine(dW,
                                height - dH - l1 - k2 * j,
                                width - dW,
                                height - dH - l1 - k2 * j);

                }

                break;

            case 3: // '\003'
                int k = (height - dH) / decade2;
                for (int j1 = 1; j1 < 10; j1++) {
                    int i2 = (int) Math.rint(log(j1) * (double) k);
                    for (int l2 = 0; l2 < decade2; l2++)
                        g.drawLine(dW,
                                height - dH - i2 - l2 * k,
                                width,
                                height - dH - i2 - l2 * k);

                }

                break;
        }
        g.setColor(color);
    }

    public String d2str(double d) {
        int i = 0;
        int j = 0;
        int k = 0;
        if ((new Double(d)).isInfinite())
            return "Inf";
        if (d != 0.0D) {
            byte byte0 = 1;
            if (d < 0.0D) {
                byte0 = -1;
                d = Math.abs(d);
            }
            while (d >= 10D) {
                d /= 10D;
                i++;
            }
            while (d < 1.0D) {
                d *= 10D;
                i--;
            }
            j = (int) d;
            if (j == 10) {
                j = 1;
                i++;
            }
            d *= 10D;
            k = (int) Math.rint(d - (double) (j * 10));
            if (k == 10) {
                j++;
                k = 0;
            }
            j *= byte0;
        }
        String s = j + "." + k + "E" + i;
        return s;
    }

    public void newParams(Vector vector) {
        params = vector;
        xMin = ((Double) params.elementAt(0)).doubleValue();
        xMax = ((Double) params.elementAt(1)).doubleValue();
        yMinMag = ((Double) params.elementAt(2)).doubleValue();
        yMaxMag = ((Double) params.elementAt(3)).doubleValue();
        yMinPhase = ((Double) params.elementAt(4)).doubleValue();
        yMaxPhase = ((Double) params.elementAt(5)).doubleValue();
        if (degree) {
            yMinPhase = (yMinPhase * 3.1415926535897931D) / 180D;
            yMaxPhase = (yMaxPhase * 3.1415926535897931D) / 180D;
        }
        precision = ((Integer) params.elementAt(6)).intValue();
        K = ((Double) params.elementAt(7)).doubleValue();
        numberDecade();
        repaint();
    }

    public Vector oldParams() {
        params = new Vector();
        params.addElement(new Double(xMin));
        params.addElement(new Double(xMax));
        params.addElement(new Double(yMinMag));
        params.addElement(new Double(yMaxMag));
        params.addElement(
                new Double(
                        degree ?
                (yMinPhase * 180D) / 3.1415926535897931D :
                yMinPhase));
        params.addElement(
                new Double(
                        degree ?
                (yMaxPhase * 180D) / 3.1415926535897931D :
                yMaxPhase));
        params.addElement(new Integer(precision));
        params.addElement(new Double(K));
        return params;
    }

    public void setBackground(Color color) {
        Color color1 = getBackground();
        super.setBackground(color);
        pcs.firePropertyChange("background", color1, color);
    }

    public void setForeground(Color color) {
        Color color1 = getForeground();
        super.setForeground(color);
        pcs.firePropertyChange("foreground", color1, color);
    }

    public void setMagColor(Color color) {
        magColor = color;
        repaint();
    }

    public Color getMagColor() {
        return magColor;
    }

    public void setPhaseColor(Color color) {
        phaseColor = color;
        repaint();
    }

    public Color getPhaseColor() {
        return phaseColor;
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    public synchronized void addMyMouseListener(
            MyMouseListener mymouselistener) {
        myMouseListeners.addElement(mymouselistener);
    }

    public synchronized void removeMyMouseListener(
            MyMouseListener mymouselistener) {
        myMouseListeners.removeElement(mymouselistener);
    }

    public void fireMyMouseEvent(MyMouseEvent mymouseevent) {
        Vector vector = null;
        synchronized (this) {
            vector = (Vector) myMouseListeners.clone();
        }
        for (int i = 0; i < vector.size(); i++) {
            MyMouseListener mymouselistener = (MyMouseListener) vector.elementAt(
                    i);
            mymouselistener.mouseOccured(mymouseevent);
        }

    }

    private Color magColor;
    private Color phaseColor;
    boolean isZero;
    boolean smallChange;
    boolean degree;
    boolean autoMag;
    boolean grid;
    boolean grid2;
    double xMin;
    double xMax;
    double yMinMag;
    double yMaxMag;
    double yMinPhase;
    double yMaxPhase;
    double constant;
    int width;
    int height;
    int precision;
    int dW;
    int dH;
    int decade;
    int decade2;
    double K;
    double angleK;
    double logK;
    double scale;
    double scale2;
    int state;
    int rootNumber;
    int phaseScale;
    int magScale;
    Vector poles;
    Vector zeros;
    Vector resultMag;
    Vector resultPhase;
    Vector params;
    Point point;
    PopupMenu pop;
    ParamFrame inputFrame;
    Menu m2;
    Menu m3;
    Menu m4;
    Menu m5;
    MenuItem m7;
    CheckboxMenuItem m1;
    CheckboxMenuItem m2_1;
    CheckboxMenuItem m2_2;
    CheckboxMenuItem m2_3;
    CheckboxMenuItem m2_4;
    CheckboxMenuItem m3_1;
    CheckboxMenuItem m3_2;
    CheckboxMenuItem m3_3;
    CheckboxMenuItem m4_1;
    CheckboxMenuItem m4_2;
    CheckboxMenuItem m4_3;
    CheckboxMenuItem m5_1;
    CheckboxMenuItem m5_2;
    CheckboxMenuItem m6;
    CheckboxMenuItem m8;
    Dimension offDimension;
    transient Image offImage;
    transient Graphics offGraphics;
    private Vector myMouseListeners;
    private PropertyChangeSupport pcs;
}
