package sound.delayStream;

import sound.Utils;
import sound.soundDemo.JavaSound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import java.awt.Container;
import java.io.IOException;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Nov 29, 2004
 * Time: 3:20:19 PM
 */
public class StreamAudio implements Runnable {
    TargetDataLine targetDataLine;
    Thread thread;
    public int delay = 10;
    private static StreamDelaySliderPanel sl = new StreamDelaySliderPanel();

    public static void main(String[] args) {
        StreamAudio sa = new StreamAudio();
        gui.ClosableJFrame cf = new gui.ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(sl);
        cf.setSize(200, 150);
        cf.show();
        sa.start();
    }

    public void start() {
        thread = new Thread(this);
        thread.setName("Capture");
        thread.start();
    }

    public void stop() {
        thread = null;
    }

    public void run() {
        initAudioStuff();
        targetDataLine.start();
        processAudioData();

        // we reached the end of the stream.  stop and close the line.
        targetDataLine.stop();
        targetDataLine.close();
        targetDataLine = null;
    }

    public int getDelay() {
        return sl.getX();
    }

    private void processAudioData() {
        AudioInputStream ais = new AudioInputStream(targetDataLine);
        StreamPlayback sp = new StreamPlayback(ais);
        sp.start();
        System.out.println("Start audio");
        while (thread != null) {
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            ais.reset();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initAudioStuff() {
        // define the required attributes for our line,
        // and make sure a compatible line is supported.

        DataLine.Info info = new DataLine.Info(TargetDataLine.class,
                Utils.get8khzMono8Format());
        if (!AudioSystem.isLineSupported(info)) {
            shutDown("Line matching " + info + " not supported.");
        }
        getAndInitTDL(info, Utils.get8khzMono8Format());
    }

    private void getAndInitTDL(DataLine.Info info, AudioFormat format) {
        // get and open the target data line for capture.

        try {
            initTargetDataLine(info, format);
        } catch (LineUnavailableException ex) {
            shutDown("Unable to open the line: " + ex);
        } catch (SecurityException ex) {
            JavaSound.showInfoDialog();
        } catch (Exception ex) {
        }
    }

    public void initTargetDataLine(DataLine.Info info, AudioFormat format)
            throws LineUnavailableException {
        targetDataLine = (TargetDataLine) AudioSystem.getLine(info);
        targetDataLine.open(format, targetDataLine.getBufferSize());
    }

    private void shutDown(String s) {
        System.out.println(s);
        System.exit(0);
    }
} // End class Capture

class StreamPlayback implements Runnable {
    SourceDataLine line;
    Thread thread;
    String errStr = null;
    AudioInputStream ais = null;
    private final int bufSize = 16384;
    public static StreamAudio str = new StreamAudio();

    StreamPlayback() {
    }

    StreamPlayback(AudioInputStream ais) {
        this.ais = ais;
    }

    public void start() {
        thread = new Thread(this);
        thread.setName("Playback");
        thread.start();
    }

    public void stop() {
        thread = null;
    }

    private void shutDown(String message) {
        if ((errStr = message) != null) {
            System.err.println(errStr);
        }
        if (thread != null) {
            thread = null;
        }
    }

    public void run() {
        AudioFormat format = Utils.get8khzMono8Format();
        AudioInputStream playbackInputStream = AudioSystem.getAudioInputStream(format, ais);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            line = (SourceDataLine) AudioSystem.getLine(info);
            line.open(format, bufSize);
        } catch (LineUnavailableException ex) {
            shutDown("Unable to open the line: " + ex);
        }
        // play back the captured audio data




        //System.out.println("DEEEEEEEEEL"+ str.delay);
        byte[] data;
        int numBytesRead = 0;
        int delay;
        // start the source data line
        line.start();
        while (thread != null) {
            delay = str.getDelay() * 500;
            data = new byte[delay];
            try {
                if ((numBytesRead = playbackInputStream.read(data)) == -1) {
                    Thread.sleep(100);
                }
                int numBytesRemaining = numBytesRead;
                while (numBytesRemaining > 0)
                    numBytesRemaining -= line.write(data, 0, numBytesRemaining);
            } catch (Exception e) {
                shutDown("Error during playback: " + e);
                break;
            }
        }
        cleanUp();
    }

    private void cleanUp() {
        // we reached the end of the stream.  let the data play out, then
        // stop and close the line.
        if (thread != null) {
            line.drain();
        }
        line.stop();
        line.close();
        line = null;
        shutDown(null);
    }
} // End class Playback



