package sound.audioDigitizer;

import sound.Utils;

import javax.sound.sampled.*;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

/**
 * Created by IntelliJ IDEA.
 * User: Douglas Lyon
 * Date: Dec 14, 2004
 * Time: 7:06:58 AM
 * Copyright DocJava, Inc.
 */
public class PlayThread extends Thread {
    byte tempBuffer[] = new byte[10000];
    AudioInputStream audioInputStream;
    SourceDataLine sourceDataLine;

    public PlayThread(AudioInputStream audioInputStream,
                      SourceDataLine sourceDataLine) {
        this.audioInputStream = audioInputStream;
        this.sourceDataLine = sourceDataLine;

    }

    public void run() {
        try {
            int cnt;
//Keep looping until the input
// read method returns -1 for
// empty stream.
            while ((cnt = audioInputStream.read(tempBuffer,
                    0, tempBuffer.length)) != -1) {
                if (cnt > 0) {
//Write data to the internal buffer of the data line
// where it will be delivered to the speaker.

                    sourceDataLine.write(tempBuffer, 0, cnt);
                }//end if
            }//end while
//Block and wait for internal
// buffer of the data line to
// empty.
            sourceDataLine.drain();
            sourceDataLine.close();
        } catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }//end catch
    }//end run

    public static void playAudio(ByteArrayOutputStream byteArrayOutputStream1) {
        try {
//Get everything set up for playback.
//Get the previously-saved data into a byte array object.
            byte audioData[] = byteArrayOutputStream1.toByteArray();
//Get an input stream on the byte array containing the data
            playAudioData(audioData);

        } catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }//end catch
    }//end playAudio

    public static void playAudioData(byte[] audioData) throws LineUnavailableException {
        InputStream byteArrayInputStream = new ByteArrayInputStream(audioData);
        AudioFormat audioFormat = Utils.get8khzMono8Format();
        AudioInputStream audioInputStream = new AudioInputStream(
                byteArrayInputStream, audioFormat,
                audioData.length / audioFormat.getFrameSize());
        DataLine.Info dataLineInfo = new DataLine.Info(
                SourceDataLine.class, audioFormat);
        SourceDataLine sourceDataLine = (SourceDataLine) AudioSystem.getLine(dataLineInfo);
        sourceDataLine.open(audioFormat);
        sourceDataLine.start();
//Create a thread to play back the data and start it running.
// It will run until all the data has been played back.
        Thread playThread = new Thread(new
                PlayThread(audioInputStream, sourceDataLine));

        playThread.run();
    }
}//end inner class sound.audioDigitizer.PlayThread
