package serialPorts;

/**
 * Created by
 * User: lyon
 * Date: Dec 29, 2003
 * Time: 10:06:24 AM
 *
 */

import gui.In;
import utils.SystemUtils;

import javax.comm.*;
import java.io.*;
import java.util.Enumeration;
import java.util.Vector;

public class Utils {
    public static void main(String[] args) {
        System.out.println();
        System.out.println("libraryPath=" + SystemUtils.getLibraryPath());
        listPorts();
        System.out.println("Make sure the dll is" +
                " in the lib path and " +
                "the properties are in the jre lib" +
                " also make sure that comm.jar is in the class path");
        dial(In.getString("enter number"));
    }

    public static void dial(String number) {
        try {
            final CommPortIdentifier aCommPort = Utils.getACommPort();
            dial(aCommPort, number);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        } catch (PortInUseException e) {
            e.printStackTrace();
        }
    }

    public void printBytes(SerialPort sp) {
        do
            printByteThread(sp);
        while (true);
    }

    private static void printByteThread(final SerialPort sp) {
        Thread t = new Thread(new Runnable() {
            public void run() {

                try {
                    InputStream is = sp.getInputStream();
                    byte byte0 = getByte(is, sp);
                    if (byte0 != -1) {
                        Character character = new Character((char) byte0);
                        String s = "";
                        if (byte0 > 31 && byte0 < 127 || byte0 == 10) {
                            s = character.toString();
                            if (byte0 == 13)
                                s = s + "\n";
                        } else {
                            s = "<" + byte0 + ">";
                        }
                        System.out.println(s);
                    }
                    Thread.sleep(0L);
                } catch (Exception exception) {
                    System.out.println("Error in TermRcvTask " +
                            exception);
                }
            }
        });
        t.start();

    }

    public static byte getByte(InputStream is, SerialPort p) {
        byte b[] = new byte[0];
        try {
            if (is == null) is = p.getInputStream();
            b = new byte[1];
            is.read(b);
        } catch (IOException e) {
            In.message(e);

        }
        return b[0];
    }

    private static void dial(CommPortIdentifier cpid, String number)
            throws IOException,
                   UnsupportedCommOperationException,
                   PortInUseException {
        SerialPort sp = initPort(cpid);
        PrintStream ps = new PrintStream(sp.getOutputStream());
                startPrintThread(sp);

        sleep();
        loud(ps);

        sleep();
        englishResultCodes(ps);

        sleep();
        //numericResultCodes(ps);
        String messageString = "atdt" + number;
        ps.print(messageString + '\r');
        sleep();
        if (In.getBoolean("hang up?"))
            hangup(ps);
        sp.close();
    }

    private static void startPrintThread(SerialPort sp)
            throws IOException {
        final DataInputStream dis =
               new DataInputStream(sp.getInputStream());
        Thread t = new Thread(new Runnable(){
            public void run(){
                try {
                    final byte x = dis.readByte();

                    System.out.print(x);
                    System.out.flush();
                    if (x==13) System.out.println();
                } catch (IOException e) {
                    In.message(e);

                }
            }
        });
        t.start();
    }

    private static SerialPort initPort(CommPortIdentifier cpid)
            throws PortInUseException, UnsupportedCommOperationException {
        SerialPort sp = (SerialPort) cpid.open("Utils", 200);
        //printByteThread(sp);
        setPort(sp);
        return sp;
    }

    private static void sleep() {
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {

        }
    }

    private static void hangup(PrintStream ps) {
        ps.print("ath0\r");
    }

    private static void loud(PrintStream ps) {
        ps.print("atL3\r");
    }
    public static void echoResult(PrintStream ps) {
        ps.print("atE1\r"+(char)13);
    }

    private static void englishResultCodes(PrintStream ps) {
        ps.print("atV1\r");
    }

    public static void numericResultCodes(PrintStream ps) {
        ps.print("atV0\r");
    }


    public static void printResponse(Reader br)
            throws IOException {
        char ca[] = new char[60];
        int i = 0;
        while ((i = br.read(ca)) != -1) {
            final String s = new String(ca, 0, i);
            System.out.print(s);
            if (s.indexOf('\r') != -1) break;
        }
        System.out.println();

    }

    private static void setPort(SerialPort sp)
            throws UnsupportedCommOperationException {
        sp.setSerialPortParams(2400,
                SerialPort.DATABITS_8,
                SerialPort.STOPBITS_1,
                SerialPort.PARITY_NONE);
        sp.setDTR(true);
        sp.setRTS(true);
        sp.setFlowControlMode(SerialPort.FLOWCONTROL_XONXOFF_IN);
        sp.setFlowControlMode(SerialPort.FLOWCONTROL_XONXOFF_OUT);
        sp.setFlowControlMode(SerialPort.FLOWCONTROL_RTSCTS_IN);
        sp.setFlowControlMode(SerialPort.FLOWCONTROL_RTSCTS_OUT);

    }


    public static void sendString(OutputStream os, String s)
            throws IOException {
        byte b[] = s.getBytes();
        os.write(b);
    }

    public static CommPortIdentifier getPortByName(String name) {
        CommPortIdentifier cpid[] = getComPortIdentifiers();
        for (int i = 0; i < cpid.length; i++) {
            if (cpid[i].getName().equals(name))
                return cpid[i];

        }
        return null;
    }

    public static CommPortIdentifier[] getComPortIdentifiers() {
        Vector v = new Vector();
        Enumeration pi = CommPortIdentifier.getPortIdentifiers();
        while (pi.hasMoreElements())
            v.addElement(pi.nextElement());
        CommPortIdentifier cpid[] = new CommPortIdentifier[v.size()];
        v.copyInto(cpid);
        return cpid;
    }

    public static CommPortIdentifier getACommPort() {
        CommPortIdentifier cpid[] = getComPortIdentifiers();
        String s[] = new String[cpid.length];
        for (int i = 0; i < s.length; i++)
            s[i] = cpid[i].getName();
        String cpn = (String) In.multiPrompt(s,
                "select a comm port (com2?)",
                "comm port dialog");
        return Utils.getPortByName(cpn);
    }

    /* If you are having trouble under OSX, use
  copy rxtx-2.1-6/MACOSX_IDE/CW/librxtxSerial.jnilib
  to:
  /System/Library/Frameworks/JavaVM.framework/Versions/1.4.1/Libraries
   or go to:
   http://home.comcast.net/~d.sopchak/macdobs/RXTX_Jag.pkg.zip
   To get the mac package.
   http://rxtx.org/ is the home page.
   Run the config as root;
   grep: /System/Library/Frameworks/JavaVM.framework/Versions/1.4.2/Home/lib/javax.comm.properties: No such file or directory
------------------------------------------------------
RxTx requires the following information in
/System/Library/Frameworks/JavaVM.framework/Versions/1.4.2/Home/lib/javax.comm.properties:

Driver=gnu.io.RXTXCommDriver

  */
    public static void listPorts() {

        System.out.println("testPortIdentifiers:start");
        CommPortIdentifier cpid[] = getComPortIdentifiers();
        if (cpid.length == 0) {
            In.message("no com ports detected, program terminates.");
            System.exit(0);
        }
        for (int i = 0; i < cpid.length; i++)
            print(cpid[i]);
        System.out.println("testPortIdentifiers:done");

    }

    public static void print(CommPortIdentifier cpid) {
        System.out.print("port:" +
                cpid.getName() +
                "\t"
                +
                "CurrentOwner:" +
                cpid.getCurrentOwner() +
                "\t"
                + "isCurrentlyOwned=" + cpid.isCurrentlyOwned());
        // isCurrentlyOwned
        // indicates if another Java
        // application owns the port.
        if (cpid.getPortType() ==
                CommPortIdentifier.PORT_SERIAL)
            System.out.println(":PORT_SERIAL");
        if (cpid.getPortType() ==
                CommPortIdentifier.PORT_PARALLEL)
            System.out.println(":PORT_PARALLEL");
    }

    public static void openAndClosePort(CommPortIdentifier cpid)
            throws PortInUseException {
        CommPort port = cpid.open("TurnTable", 20);
        System.out.println("  Opened successfully");
        port.close();
    }


    public static void testTurnTable()
            throws
            PortInUseException,
            IOException,
            UnsupportedCommOperationException {
        CommPortIdentifier portId;
        System.out.println("getPortIdentifiers...");
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        System.out.println("getPortIdentifiers... done!");

        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier) portList.nextElement();
            if
            (portId.getPortType() == CommPortIdentifier.PORT_SERIAL) {
                if (portId.getName().equals("COM3")) {
                    processPort(portId);

                }

            }

        }
    }


    private static void processPort(CommPortIdentifier portId)
            throws PortInUseException,
                   IOException,
                   UnsupportedCommOperationException {
        System.out.println("portId=" + portId.getName());
        SerialPort sp =
                openSerialPort(portId);

        OutputStream os = sp.getOutputStream();
        setUpSerialPort(sp);
        sendMagicNumber(os);
        sleepSec(10);
        moveStepperMotor(os);
        closeSerialPort(sp);
        System.out.println("port closed");
        System.in.read();
    }

    private static SerialPort openSerialPort(CommPortIdentifier portId)
            throws PortInUseException {
        return (SerialPort)
                portId.open("SimpleWriteApp", 2000);

    }

    private static void setUpSerialPort(SerialPort sp)
            throws UnsupportedCommOperationException {
        sp.setSerialPortParams(9600, SerialPort.DATABITS_8,
                SerialPort.STOPBITS_2, SerialPort.PARITY_NONE);
    }

    private static void sendMagicNumber(OutputStream os)
            throws IOException {
        byte[] mn = {27, 13, 27, 13, 27, 13, 0};
        os.write(mn);
        System.out.println("Send magic number..");
    }

    private static void moveStepperMotor(OutputStream os)
            throws IOException {
        byte[] st = {'M', 0, 0, 0, 0, 0, 0, 7, 0, 0, 13, 10};
        os.write(st);
        System.out.println("Move step.");
    }

    private static void closeSerialPort(SerialPort sp) {
//tt.step(1);
//sleepSec(2);
//tt.step(2);
//sleepSec(2);
//tt.step(3);
//sleepSec(2);

        sp.close();
    }


    public void step(OutputStream os, int n) throws IOException {
        System.out.println("Move " + n + " steps");
        byte[] st = {'M', 0, 0, 0, 0, 0, 0, 7, 0, 0, 13, 10};
        for (int i = 0; i < n; i++)
            os.write(st);
    }


    public static void sleepSec(int sec) {

        try {

            Thread.sleep(sec * 1000);

        } catch (InterruptedException e) {
        }

    }

}
