package net.stocks;

import gui.In;

import javax.swing.JPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.util.Vector;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Nov 10, 2004
 * Time: 6:31:35 PM
 */
public class QuotePanel extends JPanel {
    String symbol;
    Quote q;
    int x1 = 0;
    int y1 = 0;
    Vector history = new Vector();

    public void add(Quote q) {
        history.addElement(q);
    }

    public Quote[] getQuotes() {
        Quote qa[] = new Quote[history.size()];
        history.copyInto(qa);
        return qa;
    }

    public QuotePanel(String symbol) {
        this.symbol = symbol;
        q = Quote.makeQuote(symbol);
        add(q);
        System.out.println(q);
        setLayout(new FlowLayout());
    }

    public void paint(Graphics g) {
        Quote qa [] = getQuotes();
        for (int i = 0; i < qa.length; i++) {
            /// do your drawing here....
            //drawQuote(qa[i]);
        }
        float p = q.getPrice();
        p = (float) Math.random() * 100;
        int y2 = Math.round(p);
        int x2 = x1 + 1;
        g.drawLine(x1, y1, x2, y2);
        long v = q.getVolume() / 100000; // cause numbers come out in millions
        Dimension d = getSize();
        int w = d.width;
        int h = d.height;
        g.drawLine(x1, h - 50, x1, (int) (h - 50 - Math.abs(p)));
        g.setColor(Color.green);
        g.drawLine(0, h - 50, w, h - 50);
        g.drawLine(0, h - 50, 0, 0);
        g.setColor(Color.black);
        x1 = x2;
        y1 = y2;
        q = Quote.makeQuote(symbol);
        add(q);
        repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    public static void main(String[] args) {
        QuotePanel qp = new QuotePanel(In.getString("enter quote"));
        Frame cf = new Frame();
        cf.setLayout(new FlowLayout());
        cf.add(qp);
        cf.setSize(400, 400);
        cf.pack();
        cf.show();
    }
}
