package net.server.servlets;


/**
 * The UserAuthorizationPage class is a type of HTML page
 * which is used to prompt a user for their user id and
 * password. This information is returned to the class
 * FormProcessorServlet for validation.
 *
 * @author Robert Lysik
 * @version 1.00
 */
class UserAuthorizationPage extends net.server.servlets.HtmlPage {

    /**
     * This is the default constructor for the
     * UserAuthorizationPage class. The parent constructor
     * is caller with the page title, 'User Authorization Page'.
     * A form is added to the page which is used to prompt
     * the user to enter their user id and password. The form
     * data is passed to the FormProcessorServlet class when
     * the user clicks 'Enter'.
     */
    UserAuthorizationPage() {
        super("User Authorization Page");

        addText("Enter your user id and password, then click 'Enter'");
        addBreak();
        startForm("post",
                "http://localhost:8080/examples/servlet/FormProcessorServlet");
        addBreak();
        addText("User id: ");
        addInput("text", "txtUserId", "", "10");
        addBreak();
        // The password input type does writes the character '*'
        // for each character typed by the user, but retains the
        // actual string entered.
        addText("Password: ");
        addInput("password", "txtPassword", "", "10");
        addBreak();
        addSubmit("Enter");
        // The 'status' variable is used to determine which state
        // is currently active when processing occurs in the FormProcessorServlet.
        addHidden("status", "authorizing");
        endForm();
    }
}