package net.server.servlets;

import java.sql.*;

/**
 * DatabaseReader Class
 */

public class DatabaseReader {

// This is from mid-term
//    		deltaNew.setDriver("org.gjt.mm.mysql.Driver");
//        System.out.println( deltaNew.getDriver() );
//        deltaNew.setUrl("jdbc:mysql://JHVY501/test");

    private String driver = net.server.db.SqlBean.getDriver();

    private String url = net.server.db.SqlBean.getUrl();


    private Connection cn;
    private Statement stmt;
    private ResultSet rs;

    private String user = net.server.db.SqlBean.getUserId();
    private String password = net.server.db.SqlBean.getPassword();


    /**
     * Sets the Driver
     *
     * @parm			String		driver
     * @return       void
     */

    public void setDriver(String _driver) {
        driver = _driver;
    }

    /**
     * Sets the URL
     *
     * @parm			String		url
     * @return       void
     */

    public void setUrl(String _url) {
        url = _url;
    }

    /**
     * Sets the Connection
     *
     * @parm			String		connection
     * @return       void
     */

    public void setConnection(String _cn) {

    }

    /**
     * Sets the User
     *
     * @parm			String		user
     * @parm			String		password
     * @return       void
     */

    public void setUser(String _user, String _password) {
        user = _user;
        password = _password;
    }

    /**
     * Establishes the Database Connection
     *
     * @return       void
     * @throws       java.lang.ClassNotFoundException, Exception
     */

    public void openDatabase() throws ClassNotFoundException,
            Exception {

        System.out.println("Connecting to Database in openDatabase Method");
        System.out.println("URL is " + url + " Driver is " + driver);
        //User is " + user + "\npassword is " + password );

        try {
            Class.forName(driver);
        } catch (Exception E) {
            System.out.println("Failed on the class name");
        }

        try {
            cn = DriverManager.getConnection(url, user, password);
        } catch (Exception E) {
            System.out.println("Failed on the connection");
        }

        stmt = cn.createStatement();

    }

    /**
     * Closes the Database Connection
     *
     * @return       void
     */

    public void closeDatabase() {
        try {
            stmt.close();
            cn.close();
        } catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    /**
     * Return true/false
     *
     * @parm         String        sql
     * @return       boolean
     */

    public boolean checkRecordExists(String sql) {

        try {
            openDatabase();
            rs = stmt.executeQuery(sql);
            closeDatabase();
            return rs.next();
        } catch (ClassNotFoundException cnf) {
            System.out.println("\n ClassNotFound");
            cnf.printStackTrace();
            return false;
        } catch (SQLException sqle) {
            System.out.println("\n checkRecordExists Failure");
            sqle.printStackTrace();
            return false;
        } catch (Exception e) {
            System.out.println("\n Exception");
            e.printStackTrace();
            return false;
        }
    }

}



