package net.scp;

import futils.Futil;
import gui.In;
import gui.dialogs.ProgressDialog;
import net.ssh.jsch.*;
import net.ssh.jsch.jce.*;
import net.ssh.jsch.jcraft.Compression;

import java.io.*;

/**
 * net.scp.ScpTo A main entry into an scp client.
 * See ScpDialog for a proper GUI.
 */

public class ScpTo {
    // force the pre-loading of the SSH cryptolib
    // This fools the smart JNLP linker into including
    // the following classes (which are needed at run-time).
    // Otherwise, I get a class not found exception in
    // Java Web Start (bummer).
    Object o[] = {
        new DH(),
        new TripleDESCBC(),
        new BlowfishCBC(),
        new HMACSHA1(),
        new HMACSHA196(),
        new HMACMD5(),
        new HMACMD596(),
        new SHA1(),
        new MD5(),
        new SignatureDSA(),
        new SignatureRSA(),
        new KeyPairGenDSA(),
        new KeyPairGenRSA(),
        new SshRandom(),
        new Compression(),
        new DHGEX(),
        new DHG1()
    };

    public static void main(String[] arg) {
        scpTo();
    }

    public static void scpTo() {
        SimpleUserInfo ui = new SimpleUserInfo(
                In.getString("user id"),
                In.getPassword("enter Password"));
        String host = In.getString("host");

        String protocol = (String) In.multiPrompt(
                new String[]{"scp", "sftp"},
                "select a protocol",
                "protocol dialog");

        do {
            if (protocol.equals("scp"))
                scpTo(Futil.getReadFile("local file").toString(),
                        host,
                        In.getString("remote file"),
                        ui);
            if (protocol.equals("sftp"))
                sftpTo(Futil.getReadFile("local file").toString(),
                        host,
                        In.getString("remote file"),
                        ui);
        } while (In.getBoolean("again?"));
    }
    /**
     * A simple entry point for uploading a single
     * file to a remote system using SFTP.
     * @param localFile check this to make sure it canRead
     * @param remoteSystem a system with port 22 open
     * @param remoteFile  a file that will be overwritten!
     * @param sui a simple class that hold the uid and password
     */
    public static void sftpTo(String localFile,
                              String remoteSystem,
                              String remoteFile,
                              SimpleUserInfo sui) {
        try {

            JSch jsch = new JSch();
            Session session = jsch.getSession(sui.getUser(), remoteSystem, 22);

            session.setUserInfo(sui);

            session.connect();
            ChannelSftp c = (ChannelSftp)session.openChannel("sftp");
            c.connect();
            c.put(localFile, remoteFile, ChannelSftp.OVERWRITE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * A simple entry point for uploading a localFile
     * file to a remote system via scp.
     * @param localFile
     * @param remoteSystem
     * @param remoteFile
     * @param sui
     */
    public static void scpTo(String localFile,
                             String remoteSystem,
                             String remoteFile,
                             SimpleUserInfo sui) {
        try {

            Channel channel = getScpChannel(sui.getUser(),
                    remoteSystem,
                    sui,
                    remoteFile);
            uploadFile(channel, localFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void uploadFile(Channel channel, String localFile)
            throws IOException, JSchException {
        String command;
        // get I/O streams for remote scp
        OutputStream out = channel.getOutputStream();
        InputStream in = channel.getInputStream();

        channel.connect();

        if (checkAck(in) != 0) {
            System.exit(0);
        }

        // send "C0644 filesize filename", where filename should not include '/'
        int filesize = (int) (new File(localFile)).length();
        command = "C0644 " + filesize + " ";
        if (localFile.lastIndexOf('/') > 0) {
            command +=
                    localFile.substring(localFile.lastIndexOf('/') +
                    1);
        } else {
            command += localFile;
        }
        command += "\n";
        out.write(command.getBytes());
        out.flush();

        if (checkAck(in) != 0) {
            return;
        }

        // send a content of localFile
        FileInputStream fis = new FileInputStream(localFile);
        int fileSize = fis.available();
        ProgressDialog pd = new ProgressDialog();
        pd.setUnits(" bytes transferred");
        pd.setSize(200, 80);
        pd.setMinimum(0);
        pd.setMaximum(fileSize);
        pd.show();
        int amountTransferred = 1024;
        byte[] buf = new byte[1024];
        while (true) {
            int len = fis.read(buf,
                    0,
                    buf.length);
            if (len <= 0) break;
            out.write(buf, 0, len);
            out.flush();
            pd.setAmountDone(amountTransferred);
            amountTransferred = amountTransferred + 1024;
        }
        pd.hide();
        // send '\0'
        buf[0] = 0;
        out.write(buf, 0, 1);
        out.flush();

        if (checkAck(in) != 0) {
            System.exit(0);
        }

        return;
    }

    private static Channel getScpChannel(String user,
                                         String host,
                                         UserInfo ui, String rfile)
            throws JSchException {
        JSch jsch = new JSch();
        Session session = jsch.getSession(user, host, 22);

        session.setUserInfo(ui);
        session.connect();


        // exec 'scp -t rfile' remotely
        String command = "scp -t " + rfile;
        Channel channel = session.openChannel("exec");
        ((ChannelExec) channel).setCommand(command);
        return channel;
    }

    private static int checkAck(InputStream in)
            throws IOException {
        int b = in.read();
        // b may be 0 for success,
        //          1 for error,
        //          2 for fatal error,
        //          -1
        if (b == 0) return b;
        if (b == -1) return b;

        if (b == 1 || b == 2) {
            StringBuffer sb = new StringBuffer();
            int c;
            do {
                c = in.read();
                sb.append((char) c);
            } while (c != '\n');
            if (b == 1) { // error
                System.out.print(sb.toString());
            }
            if (b == 2) { // fatal error
                System.out.print(sb.toString());
            }
        }
        return b;
    }

   
}
