package net.rmi.utils;

import gui.In;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Oct 13, 2004
 * Time: 1:27:44 PM
 * net.rmi.utils.RmiRegistryUtils
 * Is a singleton pattern that lets you get the local registry.
 */
public final class RmiRegistryUtils {
    // use singleton pattern and
    // prevent instantiation of RmiRegistryUtils.

    private RmiRegistryUtils(){}
    // the only instance of the Registry held by the RmiRegistryUtils
    private static Registry registry;

    /**
     * Checks whether a Registry has been started on this host.
     * If not, it tries to start one.
     * when it fails to start a Registry, it exits the program
     * with exit code 1.
     */
    public static void restart() {
        if (isRegistryRunning())
            return;
        startRegistry();
    }

    private static boolean isRegistryRunning() {
        try {
            java.rmi.Naming.list("/");
            return true;
        } catch (RemoteException e) {
            return false;
        } catch (MalformedURLException e) {
            return false;
        }
    }
    /**
     * Restart the registry, if needed.
     * Return the only instance of the registry for consistent global
     * using by making use of the Singleton Design Pattern
     * @return the internally held registry instance.
     */
    public static Registry getRegistry() {
        restart();
        return registry;
    }
    private static void startRegistry() {
        try {
            registry = new sun.rmi.registry.RegistryImpl
                    (Registry.REGISTRY_PORT);
        } catch (Exception e) {
            In.message("could not start registry..."+e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String args[]) {
        restart();
        In.message("Registry Started");
    }
}
