package net.rmi.rjs;

import net.rmi.utils.RmiRegistryUtils;

import java.rmi.RemoteException;
import java.rmi.registry.Registry;

public class RmiFileServerMain {

    public static void main(String args[]) {
        
        try {
            startServer();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static void startServer()
            throws RemoteException {
        println("starting server");
        //Class c = RMIFileServerImplementation.class;
        //Compile.runRmic(c);
        RMIFileServerInterface ro = new RMIFileServerImplementation();

        bindInstances(ro);
    }

    private static void bindInstances(RMIFileServerInterface ro)
            throws RemoteException {
        println("binding remote instances");
        Registry r = RmiRegistryUtils.getRegistry();

        r.rebind(RMIFileServerImplementation.REMOTE_NAME, ro);
        println("waiting for invocations");
    }


    public static void println(Object o) {
        System.out.println(o);
    }
}
