package net.rmi.pawelGrid.LusCs;

import gui.JInfoFrame;
import net.multicast.McastUtil;

import java.io.*;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;


public class LusRcvr extends Thread {
    private McastUtil mcu;
    private JInfoFrame jif;
    private Vector v;
    public InetAddress lusIp;
    public InetAddress ip;
    public static String IP  = null;
    public String mfloops = null;


    public LusRcvr(McastUtil mcu, JInfoFrame jif, Vector v) {
        this.jif = jif;
        this.mcu = mcu;
        this.v = v;
        start();                // start calls run
    }

    public void run() {
        try {
            while (true) {
                processBytes();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processBytes() throws IOException {

        mcu.getBytes();
        ip = mcu.getReceiveAddress();
        lusIp = mcu.getSendAddress();
        InetAddress.getLocalHost().toString();
        CsRecord csr = new CsRecord();
        csr.setmflops1("11.64");
        csr.setCSip(ip.toString().substring(1, ip.toString().length()));
        connectToCS(csr.getCSip());
        csr.setscSpeed("Unknow");
        csr.setState("Idle");
        v.add(csr);

        jif.println("");
        String out = "   Index: " + v.indexOf(csr)
                + "      CServer IP: " + csr.getCSip()
                + "      CPU Speed: " + csr.getscSpeed()
                + "      CPU State: " + csr.getState()
                + "      Benchmark MFlops/s: " + csr.getmflops1();
        jif.println(out);
        for (int j = 0; j <= out.length() + 50; j++)
            jif.print("-");



    }


    public void printAllVecRecords(Vector csList) {
        System.out.println("size csList" + csList.size());
        CsRecord csr;

        for (int i = 0; i < csList.size(); i++) {

            csr = (CsRecord) csList.elementAt(i);
            jif.println();
            String out = "   Index: " + v.indexOf(csr)
                    + "      CServer IP: " + csr.getCSip()
                    + "      CPU Speed: " + csr.getscSpeed()
                    + "      CPU State: " + csr.getState()
                    + "      Benchmark MFlops/s: " + csr.getmflops1();
            jif.println(out);
            for (int j = 0; j <= out.length() + 50; j++)
                jif.print("-");
            jif.println();

        }
    }

    public InetAddress getSendAddress() {
        return mcu.getSendAddress();
    }

    public String getLusIp() throws IOException {
        System.out.println("from lus my ip " +
                InetAddress.getLocalHost().getHostAddress().toString());
        IP = InetAddress.getLocalHost().getHostAddress().toString();
        return InetAddress.getLocalHost().getHostAddress().toString();
        //return address.getHostAddress().toString();
    }

    public void connectToCS(String ip) {
        try {
            //InetAddress addr = InetAddress.getByName(ip);
            //System.out.println("inte add socket "+ addr);
            Socket socket = new Socket(ip, 1200);
            System.out.println("socked opened");
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            System.out.println("writing lus ip " + getLusIp());
            wr.write(getLusIp());
            wr.flush();
            socket.close();

        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
    }
}
