package net.rmi.pawelGrid.LusCs;


/**

 * Created by IntelliJ IDEA.

 * User: pkrepszt

 * Date: Feb 16, 2005

 * Time: 3:52:17 PM

 * To change this template use File | Settings | File Templates.

 */

//package net.multicast;

import futils.Futil;
import gui.In;
import gui.JInfoFrame;
import gui.run.RunButton;
import net.multicast.McastUtil;
import net.rmi.pawelGrid.RmiFileTrans.FileServerImplemention;
import net.rmi.pawelGrid.RmiFileTrans.FileTransClient;

import java.awt.*;
import java.io.File;
import java.util.Vector;


public class Lus {
    private int mcastPort = 7234;
    private McastUtil mcx = new McastUtil(mcastPort);
    private JInfoFrame jif = new JInfoFrame("LAN LUS");
    private FileTransClient ftc = new FileTransClient();
    private static Vector CsRecordListHolder = new Vector();
    private static CsRecord record;
    private static LusRcvr lusRcvr;


    public static void main(String[] args) {
        // new FileServer();
        new Lus();
    }

    public Lus() {
        mcx.enableLoopBack();
        processWithMulticastSocket();
    }

    public static void updateInfoFrame(String ip) {
        for (int i = 0; i < getCsRecordListHolder().size(); i++) {
            CsRecord csr = (CsRecord) getCsRecordListHolder().elementAt(
                    i);
            String csIp = csr.getCSip();
            if (csIp.equals(ip))
                csr.setState("Idle");
        }
        lusRcvr.printAllVecRecords(getCsRecordListHolder());
    }

    public void processWithMulticastSocket() {

        // ChatRcvr will handle the incoming
        // Data and print it out to STDN output.
        lusRcvr = new LusRcvr(mcx, jif, getCsRecordListHolder());
        Container c = jif.getContentPane();

        c.add(
                new RunButton("Get Jar File") {
                    public void run() {
                        getJar();
                    }
                }, BorderLayout.SOUTH);

        jif.setSize(700, 300);
        jif.show();
        System.out.println("size " + getCsRecordListHolder().size());
    }
// replace with real job factory leater

    public void getJar() {
        Thread t = new Thread(
                new Runnable() {
                    public void run() {
                        File jar = Futil.getReadFile("select a jar file");
                        if (jar == null)
                            return;
                        System.out.println(
                                " now  it size " +
                                getCsRecordListHolder().size());
                        String rmiUrl = getBestRmiUrl();
                        if (rmiUrl == null)
                            return;
                        System.out.println(" Best Ip is " + rmiUrl);
                        // now send this jar to CS RMI?

                        ftc.putJobJar(rmiUrl, jar);

                    }
                });
        t.start();
    }

    // get the CS ip that the job will be send
    /**
     * String location = "rmi://" +serverHostName +"/" +REMOTE_NAME;
     */
    public String getBestRmiUrl() {
        String ipAddress = getIpAddress();
        if (ipAddress == null)
            return null;
        String s = "rmi://" +
                ipAddress +
                "/" +
                FileServerImplemention.REMOTE_NAME;
        System.out.println("rmiUrl=" + s);
        return s;
    }

    private String getIpAddress() {
        int n = getCsRecordListHolder().size();
        if (n == 0) In.message("Danger, no Computer Servers available!");
        System.out.println("size " + n);
        CsRecord csr;
        String out = null;
        float speed = 0.0f;
        float privSpeed = 0.0f;
        for (int i = 0; i < getCsRecordListHolder().size(); i++) {
            csr = (CsRecord) getCsRecordListHolder().elementAt(i);
            System.out.println("speed = " + csr.getmflops1());
            speed = Float.parseFloat(csr.getmflops1());
            if (speed > privSpeed && (!csr.getState().equals("Busy"))) {
                out = csr.getCSip();
                record = csr;
            }
        }
        if (out == null) {
            System.out.println("There is no CS avalable ");
            return null;
        }
        record.setState("Busy");
        lusRcvr.printAllVecRecords(getCsRecordListHolder());
        return out;
    }

    public static Vector getCsRecordListHolder() {
        return CsRecordListHolder;
    }

    public static void setCsRecordListHolder(Vector csRecordListHolder) {
        Lus.CsRecordListHolder = csRecordListHolder;
    }


}





