package net.rmi.pawelGrid.LusCs;

import gui.JInfoFrame;
import math.benchmarks.Linpack;
import net.rmi.pawelGrid.RmiFileTrans.FileServer;
import net.multicast.McastUtil;

import java.io.IOException;


/**
 * Created by IntelliJ IDEA.
 * <p/>
 * User: pkrepszt
 * <p/>
 * Date: Feb 21, 2005
 * <p/>
 * Time: 1:58:58 PM
 * <p/>
 */

public class CServer {

    private int mcastPort = 7234;
    private McastUtil mcx = new McastUtil(mcastPort);
    private JInfoFrame jif = new JInfoFrame("CServer");
    private static double mflops;
    private static String lusIP = null;

    public static void main(String[] args) {
        new CServer();
    }

    public CServer() {
        processWithMulticastSocket();
        new FileServer();
    }

    public void processWithMulticastSocket() {

        mcx.enableLoopBack();
        Linpack l = new Linpack();
        setMflops(l.getResults().getMflops());
        System.out.println("From CS MF: " + getMflops());
        new CSRcvr(mcx, jif);

       try {
           sendALine(String.valueOf(getMflops()));
        } catch (IOException e) {
            e.printStackTrace();
        }
        jif.setSize(600, 200);
        jif.show();
        jif.println("Conecting to LUS...");
        jif.println("Benchmark linpack mflops : " + getMflops());
    }
    private void sendALine(String s)
            throws IOException {
        mcx.sendBytes(s.getBytes());
    }

    public static double getMflops() {
        return mflops;
    }

    public static void setMflops(double mflops) {
        CServer.mflops = mflops;
    }

    public static String getLusIP() {
        return lusIP;
    }

    public static void setLusIP(String lusIP) {
        CServer.lusIP = lusIP;
    }
}





