package net.rmi;

import net.rmi.utils.RmiRegistryUtils;

import java.io.Serializable;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class ComputeServer
    extends UnicastRemoteObject
    implements Computable {

  // rmi servers must have
  // a public constructor that throws a
  // RemoteException
  public ComputeServer() throws RemoteException {
  }

  //in rmi, parameters must be serializale
  public void println(Serializable o)
      throws RemoteException {
    System.out.println(o);
  }

  //servers must gui.run RMIC
  public static void main(String[] args)
      throws RemoteException {
    //System.setSecurityManager(
    //    new RMISecurityManager());
    try {
      lookUpServerAndBindWithRegistry();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  private static void lookUpServerAndBindWithRegistry()
          throws java.rmi.RemoteException,
          java.net.MalformedURLException {

    ComputeServer cs =
        new ComputeServer();
    String url =
        "rmi://localhost/ComputeServer";
      Registry r = RmiRegistryUtils.getRegistry();
      r.rebind(url,cs);
    //java.rmi.Naming.rebind(url, cs);
    System.out.println("server started");
  }
}
