package net.multicast.multiMedia;

import gui.In;
import gui.dialogs.LabeledItemPanel;
import gui.run.RunButton;
import gui.run.RunCheckBox;
import net.multicast.chat.ChatMain;
import sound.audioDigitizer.StreamingAudioMulticastRcvr;

import javax.swing.*;

/**
 * This class demonstrates the usage of the StandardDialog class.
 */
public class MultiCastDialog extends JDialog {
    MultiCastBean mcb = MultiCastBean.restore();
    private boolean isTransmitSelected = mcb.isVideoXmt();
    private boolean isReceiveSelected = mcb.isVideoRcv();

    public MultiCastDialog() {
        init();
    }

    private void init() {
        setTitle("Multicast Dialog");
        setModal(false);
        LabeledItemPanel c = new LabeledItemPanel();
        c.addItem("Audio", getAudioRcvXmit());
        c.addItem("Video", getVideoRcvXmit());
        c.addItem("Chat", getChatRcvXmit());
        c.addItem("Process", new RunButton("OK") {
            public void run() {
                okPressed();
            }
        });
        c.setBorder(BorderFactory.createEtchedBorder());
        setContentPane(c);
    }

    private JPanel getAudioRcvXmit() {
        JPanel jp = new JPanel();
        jp.add(new RunCheckBox("[Receive", mcb.isAudioRcv()) {
            public void run() {
                mcb.setAudioRcv(isSelected());
            }
        });
        jp.add(new RunCheckBox("[Transmit", mcb.isAudioXmt()) {
            public void run() {
                mcb.setAudioXmt(isSelected());
            }
        });
        return jp;
    }

    private JPanel getVideoRcvXmit() {
        JPanel jp = new JPanel();
        final RunCheckBox rcbReceive = new RunCheckBox("[Receive", mcb.isVideoRcv()) {
            public void run() {
                if (isSelected()) isReceiveSelected = true;
                if (!isSelected()) isReceiveSelected = false;
                if (isTransmitSelected) {
                    setSelected(false);
                }
                mcb.setVideoRcv(isSelected());
            }
        };

        jp.add(rcbReceive);
        final RunCheckBox rcbTransmit = new RunCheckBox("[Transmit", mcb.isVideoXmt()) {
            public void run() {
                if (isSelected()) isTransmitSelected = true;
                if (!isSelected()) isTransmitSelected = false;
                if (isReceiveSelected) {
                    setSelected(false);
                }
                mcb.setVideoXmt(isSelected());
            }
        };
        jp.add(rcbTransmit);
        return jp;
    }

    private JPanel getChatRcvXmit() {
        JPanel jp = new JPanel();
        jp.add(new RunCheckBox("[Receive", mcb.isChatRcv()) {
            public void run() {
                mcb.setChatRcv(isSelected());
            }
        });
        jp.add(new RunCheckBox("[Transmit", mcb.isChatXmt()) {
            public void run() {
                mcb.setChatXmt(isSelected());
            }
        });
        return jp;
    }

    /**
     * This method gets the values of the panel entry fields.
     *
     * @return an object containing the Customer data
     */
    public MultiCastBean getData() {
        return mcb;
    }

    public void okPressed() {
        if (isValidData()) {
            mcb.save();
            setVisible(false);
            processOk();
        } else
            debugData();
    }

    private void processOk() {
        System.out.println("OK process!");
        System.out.println("Validate the data and capture...");
        audioSelection();
        chatSelection();
        videoSelection();
    }

    private void videoSelection() {
        if (mcb.isVideoXmt()) {

            new BroadcastMainXmt();
        } else if (mcb.isVideoRcv()) {
            new BroadcastMainRcv();
        }
    }

    private void audioSelection() {
        if (mcb.isAudioRcv() && mcb.isAudioXmt()) {
            MainAudioMcastXmitter sa = new MainAudioMcastXmitter();
            sa.start();
            sound.audioDigitizer.StreamingAudioMulticastRcvr
                    s = new StreamingAudioMulticastRcvr();
            s.start();
        } else if (mcb.isAudioRcv() && !mcb.isAudioXmt()) {
            StreamingAudioMulticastRcvr
                    s = new StreamingAudioMulticastRcvr();
            s.start();
        } else if (mcb.isAudioXmt() && !mcb.isAudioRcv()) {
            MainAudioMcastXmitter sa = new MainAudioMcastXmitter();
            sa.start();
        }
    }

    private void chatSelection() {
        if (mcb.isChatRcv() && mcb.isChatXmt()) {
            new ChatMain();
        } else if (mcb.isChatRcv() && !mcb.isChatXmt()) {
            new ChatReceiver();
        } else if (mcb.isChatXmt() && !mcb.isChatRcv()) {
            new ChatXmitter();
        }
    }

    public void debugData() {
        In.message("Data not valid! Model: " + mcb);
    }

    /**
     * This method checks that the data entered is valid.
     *
     * @return <code>true</code> if the data is valid, otherwise
     *         <code>false</code>
     */
    protected boolean isValidData() {
        return mcb.isValidData();
    }

    public static void main(String[] args) {
        MultiCastDialog dialog = new MultiCastDialog();
        dialog.pack();
        dialog.show();
    }
}