package net.multicast.multiMedia;

import futils.Futil;
import futils.ReaderUtil;
import gui.JInfoFrame;
import gui.run.RunTextField;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import net.multicast.McastUtil;
import net.multicast.chat.ChatRcvr;

/**
 * Copyright DocJava, inc. User: lyon Date: Oct 27, 2004 Time: 4:59:20 AM
 */
public class ChatXmitter {
    private int port = 1234;
    private McastUtil mcx = new McastUtil(port);
    private JInfoFrame jif = new JInfoFrame();

    public JInfoFrame getChatFrame() {
        return jif;
    }

    public static void main(String[] args) {
        ChatXmitter cm = new ChatXmitter();
    }

    public ChatXmitter() {
        mcx.enableLoopBack();
        processWithMulticastSocket();
    }

    public void processWithMulticastSocket() {
        Container c = jif.getContentPane();
        RunTextField rtf = new RunTextField() {
            public void run() {
                try {
                    sendALine(getText());
                    setText("");
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        c.add(rtf, BorderLayout.CENTER);
        jif.setSize(400, 75);
        jif.show();
    }

    private void sendALine(String strin)
            throws IOException {
        if (strin.startsWith("open:")) {
            sendAFile();
        }
        mcx.sendBytes(strin.getBytes());
    }

    private void sendAFile() {
        System.out.println("SendAFile_");
        File f = Futil.getReadFile("select a text file");
        sendAFile(f);
    }

    private void sendAFile(File f) {
        try {
            String sa[] = ReaderUtil.getFile(f);
            byte b[] = ReaderUtil.getBytes(sa);
            mcx.sendBytes(b);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}

