package net.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class Smtp implements Runnable {

    private String recipientEmail = null;
    private String senderEmail = null;
    private String serverHostName = null;
    private String message = null;

    private int smtpPort = 25;

    private Socket emailClientSocket;
    private PrintWriter pw;
    private BufferedReader br;
    private InetAddress internetAddressOfSocketToTheSMTPServer;
    private InetAddress myLocalInternetAddress;


    Thread thread = new Thread(this);

    public void emailLyon(String msg) {
        email(msg,
                "localhost",
                "lyon@company.mail",
                "lyon@company.mail");
    }

    public void email(String msg,
                      String serverHostName,
                      String recipientEmail,
                      String senderEmail) {
        setSenderEmail(senderEmail);
        setRecipientEmail(recipientEmail);
        setMailServerHostName(serverHostName);
        setMessage(msg);
        run();
    }

    public void start() {
        thread.start();
    }


    public void run() {
        try {
            send();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void send() throws IOException {

        emailClientSocket = new Socket(serverHostName, smtpPort);
        try {
            internetAddressOfSocketToTheSMTPServer = emailClientSocket.getInetAddress();
            // check permission of incomming host
            // to see if we should allow it access to
            // the smtp services.
            myLocalInternetAddress = InetAddress.getLocalHost();

            pw = new PrintWriter(emailClientSocket.getOutputStream());
            br = new BufferedReader(
                    new InputStreamReader(
                            emailClientSocket.getInputStream()
                    )
            );
            sendline("HELO " + myLocalInternetAddress.toString());
            sendline("MAIL FROM:" + senderEmail);
            sendline("RCPT TO:" + recipientEmail);
            sendline("DATA");
            sendline(message);
            sendline(".");


        } catch (Exception c) {
            emailClientSocket.close();
            System.out.println(
                    "Error; message send failed:\n "
                    + c.getMessage());
        }
        emailClientSocket.close();
    }

    void sendline(String data) throws IOException {
        pw.println(data);
        pw.flush();
        String s = br.readLine();
        System.out.println("sendline in:" + s);
    }

    public void setMessage(String msg) {
        message = msg;
    }

    public void setSenderEmail(String email) {
        senderEmail = email;
    }

    public void setRecipientEmail(String email) {
        recipientEmail = email;
    }

    public void setMailServerHostName(String host) {
        serverHostName = host;
    }

    public static void main(String args[]) {
        Smtp sm = new Smtp();
        for (int i = 0; i < 1000; i++) {
            sm.emailLyon("This is a test!!");
            System.out.println("Thread was started to send an email");
        }
    }


}