package math.approximations;

import java.util.*;
/**
 * Calcualtes hermite polynomials.
 *
 * @author W. Christian
 * @version 1.0
 */

public class Hermite {

  static final ArrayList hermiteList;
  static final Polynomial twoX = new Polynomial(new double[] {0, 2.0});  // 2x used in recursion

  private Hermite() {
  }

  public static synchronized Polynomial getPolynomial(int n) {
    if (n < hermiteList.size())return (Polynomial) hermiteList.get(n);
    Polynomial p1 = getPolynomial(n - 1).multiply(twoX);
    Polynomial p2 = getPolynomial(n - 2).multiply(2 * (n - 1));
    return p1.subtract(p2);
  }

  static {
    hermiteList = new ArrayList();
    Polynomial p = new Polynomial(new double[] {1.0});
    hermiteList.add(p);
    p = new Polynomial(new double[] {0, 2.0});
    hermiteList.add(p);
  }



}
