package math;

import futils.LineProcessor;
import futils.PolymorphicProcessor;


/**
 * GPL code by DocJava, Inc.
 * User: lyon
 * Date: Mar 5, 2003
 * Time: 4:33:57 PM
 * 
 */
public class Stats  {
    // k = number of intensities
    private static final int k = 256;
    private double PMF[] = new double[k];
    private double[] CMF = new double[k];
    public static int count = 0;
    public static int sum = 0;


    public double[] getPMF() {
        return PMF;
    }

    public double[] getCMF() {
        return CMF;
    }

    protected void computeCMF() {
        double cumulative = 0;
        for (int i = 0; i < getPMF().length; i++) {
            cumulative = cumulative + getPMF()[i];
            CMF[i] = cumulative;
        }
    }

    public void printPMF() {
        System.out.println("PMF");
        for (int i = 0; i < getPMF().length; i++) {
            System.out.println(getPMF()[i]);
        }
    }

    public void printCMF() {
        System.out.println("CMF");
        for (int i = 0; i < CMF.length; i++) {
            System.out.println(CMF[i]);
        }
    }

    public void initStats(short plane[][]) {
        int width = plane.length;
        int height = plane[0].length;
        int total = 0;
        for (int i = 0; i < width; i++)
            for (int j = 0; j < height; j++) {
                getPMF()[plane[i][j] & 0xFF]++;
                total++;
            }
        // Normalize
        for (int i = 0; i < 256; i++)
            getPMF()[i] = (getPMF()[i] / total);
        computeCMF();
    }

    public void setPMF(double[] PMF) {
        this.PMF = PMF;
    }

    public static void newNumber(String s){
        count++;
        int i = Integer.parseInt(s);
        sum = sum + i;
    }

    public static void averageNumbers() {
        new PolymorphicProcessor(
                new LineProcessor() {
                    public void process(String s) {
                        newNumber(s);
                    }
                }
        );
        System.out.println("avg="+sum/count);

    }

    public static void main(String args[]){
        averageNumbers();
    }
}
