package j3d.utils.propertyEditors;

import javax.swing.*;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;

public abstract class PropertyEditorBuilder {

    public abstract void addEventListener(Object obj, Method writeMethod);

    public abstract JComponent getSwingJComponent();

    public static PropertyDescriptor getPropertyDescriptor(Object obj,
                                                           String property) {
        String propertyName = Character.toLowerCase(property.charAt(0)) +
                property.substring(1);
        Class type = obj.getClass();
        try {
            return new PropertyDescriptor(property, type);
        } catch (IntrospectionException ie) {
            System.out.println("No such property as '" + property + "' in " + type + ".\n" + ie);
            return null;
        }
    }

    protected void init(Object obj, String name) {
        init(obj, name, true);
    }

    protected void init(Object obj, String name, boolean timer) {
        PropertyDescriptor pd = getPropertyDescriptor(obj, name);
        addEventListener(obj, pd.getWriteMethod());
        Method reader = pd.getReadMethod();
        // Initialize the component to its starting value.
        setSwingJComponentFromObject(obj, reader);
        if (timer) startTimer(obj, reader);
    }

    public static Object readFromObject(Object obj, Method reader) {
        try {
            return reader.invoke(obj, new Object[]{});
        } catch (InvocationTargetException ie) {
            System.out.println("InvocationTargetException: " + ie.getCause());
        } catch (IllegalAccessException ie) {
            System.out.println("IllegalAccessException: " + ie);
        }
        return null;
    }

    public abstract void setSwingJComponentFromObject(final Object obj,
                                                      final Method reader);

    public void startTimer(final Object obj, final Method reader) {
        new Timer().schedule(new TimerTask() {
            // This TimerTask is a call to the setSwingJComponentFromObject() method
            // in the builder object created for this SwingComponent.  The Builder
            // persists indefinitely.  It contains a reference to the Swing
            // Component being updated. In fact, this method is being executed within
            // that particular Builder.
            public void run() {
                setSwingJComponentFromObject(obj, reader);
            }
        },
                0,
                50);
        ;
    }

    public static void writeToObject(Object obj, Method writer, Object value) {
        try {
            writer.invoke(obj, new Object[]{value});
        } catch (InvocationTargetException ie) {
        } catch (IllegalAccessException ie) {
        }
    }

}