package j3d.utils.propertyEditors;

import javax.swing.*;
import java.awt.*;
import java.lang.reflect.Method;


public class PERadioButtonGroupBuilder extends PropertyEditorBuilder {

    private JPanel buttonGroupPanel;

    public PERadioButtonGroupBuilder(String[] choices, Object obj, String name) {
        buttonGroupPanel = new JPanel(new GridLayout(0, choices.length));
        ButtonGroup bg = new ButtonGroup();
        final Method reader = getPropertyDescriptor(obj, name).getReadMethod();
        for (int i = 0; i < choices.length; i++) {
            PERadioButtonBuilder surbb = new PERadioButtonBuilder(obj, name);
            JRadioButton rb = (JRadioButton) surbb.getSwingJComponent();
            rb.setText(choices[i]);
            bg.add(rb);
            buttonGroupPanel.add(rb);
        }
    }

    /**
     * Declare a non-functioning addEventListener() so that this class
     * will not be abstract.  The panel itself is not responded to, only
     * the buttons in the panel.
     */
    public void addEventListener(final Object obj, final Method writer) {
    }

    public JComponent getSwingJComponent() {
        return buttonGroupPanel;
    }

    /**
     * Declare a non-functioning setComponentFromObject() so that this class
     * will not be abstract.  The panel itself is not set by an object, only
     * the buttons in the panel.
     */
    public void setSwingJComponentFromObject(final Object obj, final Method reader) {
    }

}