package j3d.utils;

/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */

import gui.layouts.LeftAlignComponent;
import gui.run.*;

import javax.media.j3d.Appearance;
import javax.media.j3d.TexCoordGeneration;
import javax.swing.*;
import javax.vecmath.Vector4f;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Note: this editor only handles 2D tex gen
 */


public class TexCoordGenerationEditor extends Box
        implements Java3DExplorerConstants {

    // TexCoordGeneration
    Appearance app;
    TexCoordGeneration texGen;
    boolean enable;
    int mode;
    Vector4f planeS = new Vector4f();
    Vector4f planeT = new Vector4f();

    public TexCoordGenerationEditor(Appearance initApp, boolean initEnable,
                                    int initMode, Vector4f initPlaneS, Vector4f initPlaneT) {

        super(BoxLayout.Y_AXIS);
        app = initApp;
        enable = initEnable;
        mode = initMode;
        planeS.set(initPlaneS);
        planeT.set(initPlaneT);
        setTexGen(); // set up the initial texGen

        JCheckBox enableCheckBox = new JCheckBox("Enable Tex Coord Gen");
        enableCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                enable = ((JCheckBox) e.getSource()).isSelected();
                texGen.setEnable(enable);
            }
        });
        add(new LeftAlignComponent(enableCheckBox));


        // texture boundaries
        String[] modeNames = {
            "OBJECT_LINEAR",
            "EYE_LINEAR",
            "SPHERE_MAP",
            "NORMAL_MAP",
            "REFLECTION_MAP"
        };
        int[] modeValues = {
            TexCoordGeneration.OBJECT_LINEAR,
            TexCoordGeneration.EYE_LINEAR,
            TexCoordGeneration.SPHERE_MAP,
            TexCoordGeneration.NORMAL_MAP,
            TexCoordGeneration.REFLECTION_MAP
        };

        // tex gen modes
        IntChooser modeChooser = new IntChooser("Generation Mode:",
                modeNames, modeValues);
        modeChooser.setValue(mode);
        modeChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                int value = event.getValue();
                mode = value;
                setTexGen();
            }
        });
        add(modeChooser);

        // make a panel for both sets of sliders and then two sub-panels,
        // one for each group of sliders
        Box sliderPanel = new Box(BoxLayout.Y_AXIS);
        add(sliderPanel);

        Box planeSPanel = new Box(BoxLayout.Y_AXIS);
        Box planeTPanel = new Box(BoxLayout.Y_AXIS);
        sliderPanel.add(planeSPanel);
        sliderPanel.add(planeTPanel);

        planeSPanel.add(new LeftAlignComponent(new JLabel("Plane S:")));
        FloatLabelJSlider planeSxSlider = new FloatLabelJSlider("X:", 0.1f, -10.0f, 10.0f, planeS.x);
        planeSxSlider.setMajorTickSpacing(0.1f);
        planeSxSlider.setPaintTicks(true);
        planeSxSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                planeS.x = e.getValue();
                setTexGen();
            }
        });
        planeSPanel.add(planeSxSlider);

        FloatLabelJSlider planeSySlider = new FloatLabelJSlider("Y:", 0.1f, -10.0f, 10.0f, planeS.y);
        planeSySlider.setMajorTickSpacing(0.1f);
        planeSySlider.setPaintTicks(true);
        planeSySlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                planeS.y = e.getValue();
                setTexGen();
            }
        });
        planeSPanel.add(planeSySlider);

        FloatLabelJSlider planeSzSlider = new FloatLabelJSlider("Z:", 0.1f, -10.0f, 10.0f, planeS.z);
        planeSzSlider.setMajorTickSpacing(0.1f);
        planeSzSlider.setPaintTicks(true);
        planeSzSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                planeS.z = e.getValue();
                setTexGen();
            }
        });
        planeSPanel.add(planeSzSlider);

        FloatLabelJSlider planeSwSlider = new FloatLabelJSlider("W:", 0.1f, -10.0f, 10.0f, planeS.w);
        planeSwSlider.setMajorTickSpacing(0.1f);
        planeSwSlider.setPaintTicks(true);
        planeSwSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                planeS.w = e.getValue();
                setTexGen();
            }
        });
        planeSPanel.add(planeSwSlider);

        planeSPanel.add(new LeftAlignComponent(new JLabel("Plane T:")));
        FloatLabelJSlider planeTxSlider = new FloatLabelJSlider("X:", 0.1f, -10.0f, 10.0f, planeT.x);
        planeTxSlider.setMajorTickSpacing(0.1f);
        planeTxSlider.setPaintTicks(true);
        planeTxSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                planeT.x = e.getValue();
                setTexGen();
            }
        });
        planeTPanel.add(planeTxSlider);

        FloatLabelJSlider planeTySlider = new FloatLabelJSlider("Y:", 0.1f, -10.0f, 10.0f, planeT.y);
        planeTySlider.setMajorTickSpacing(0.1f);
        planeTySlider.setPaintTicks(true);
        planeTySlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                planeT.y = e.getValue();
                setTexGen();
            }
        });
        planeTPanel.add(planeTySlider);

        FloatLabelJSlider planeTzSlider = new FloatLabelJSlider("Z:", 0.1f, -10.0f, 10.0f, planeT.z);
        planeTzSlider.setMajorTickSpacing(0.1f);
        planeTzSlider.setPaintTicks(true);
        planeTzSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                planeT.z = e.getValue();
                setTexGen();
            }
        });
        planeTPanel.add(planeTzSlider);

        FloatLabelJSlider planeTwSlider = new FloatLabelJSlider("W:", 0.1f, -10.0f, 10.0f, planeT.w);
        planeTwSlider.setMajorTickSpacing(0.1f);
        planeTwSlider.setPaintTicks(true);
        planeTwSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                planeT.w = e.getValue();
                setTexGen();
            }
        });
        planeTPanel.add(planeTwSlider);
    }

    void setTexGen() {
        texGen = new TexCoordGeneration(mode,
                TexCoordGeneration.TEXTURE_COORDINATE_2, planeS, planeT);
        texGen.setCapability(TexCoordGeneration.ALLOW_ENABLE_WRITE);
        texGen.setEnable(enable);
        app.setTexCoordGeneration(texGen);
    }
}
