/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Mar 3, 2004
 * Time: 2:32:59 PM
 * 
 */
package j3d.utils;

import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.PlatformGeometry;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.*;

public class ShapeCollection {
    public static Shape3D getLand() {
        int numberOfLines = 888;
        LineArray la = new LineArray(numberOfLines,
                GeometryArray.COORDINATES
                | GeometryArray.COLOR_3);
        float l = -50.0f;
        for (int c = 0; c < numberOfLines; c += 4) {

            la.setCoordinate(c + 0, new Point3f(-50.0f, 0f, l));
            la.setCoordinate(c + 1, new Point3f(50.0f, 0.0f, l));
            la.setCoordinate(c + 2, new Point3f(l, 0.0f, -50.0f));
            la.setCoordinate(c + 3, new Point3f(l, 0.0f, 50.0f));
            l += 1.0f;
        }

        Color3f c = new Color3f(0.8f, 0.1f, 0.1f);
        for (int i = 0; i < numberOfLines; i++) la.setColor(i, c);

        return new Shape3D(la);
    }

    public static QuadArray getHouse() {
        QuadArray qa = new QuadArray(28, GeometryArray.COORDINATES | GeometryArray.COLOR_3);

        qa.setCoordinate(0, new Point3f(0f, 0f, 0f));
        qa.setCoordinate(1, new Point3f(1f, 0f, 0f));
        qa.setCoordinate(2, new Point3f(1f, 1f, 0f));
        qa.setCoordinate(3, new Point3f(0f, 1f, 0f));

        qa.setCoordinate(4, new Point3f(0.4f, 0f, 0.01f));
        qa.setCoordinate(5, new Point3f(0.6f, 0f, 0.01f));
        qa.setCoordinate(6, new Point3f(0.6f, .5f, 0.01f));
        qa.setCoordinate(7, new Point3f(0.4f, .5f, 0.01f));

        qa.setCoordinate(8, new Point3f(0.2f, .60f, 0.01f));
        qa.setCoordinate(9, new Point3f(0.4f, 0.6f, 0.01f));
        qa.setCoordinate(10, new Point3f(0.4f, 0.8f, 0.01f));
        qa.setCoordinate(11, new Point3f(0.2f, 0.8f, 0.01f));

        qa.setCoordinate(12, new Point3f(0.6f, .60f, 0.01f));
        qa.setCoordinate(13, new Point3f(0.8f, 0.6f, 0.01f));
        qa.setCoordinate(14, new Point3f(0.8f, 0.8f, 0.01f));
        qa.setCoordinate(15, new Point3f(0.6f, 0.8f, 0.01f));

        qa.setCoordinate(16, new Point3f(0f, 1f, 0f));
        qa.setCoordinate(17, new Point3f(0.5f, 1f, 0f));
        qa.setCoordinate(18, new Point3f(0.5f, 1.3f, 0f));
        qa.setCoordinate(19, new Point3f(0f, 1f, 0f));

        qa.setCoordinate(20, new Point3f(1f, 1f, 0f));
        qa.setCoordinate(21, new Point3f(0.5f, 1.3f, 0f));
        qa.setCoordinate(22, new Point3f(0.5f, 1f, 0f));
        qa.setCoordinate(23, new Point3f(1f, 1f, 0f));

        qa.setCoordinate(24, new Point3f(0.1f, 1f, -0.01f));
        qa.setCoordinate(25, new Point3f(0.2f, 1f, -0.01f));
        qa.setCoordinate(26, new Point3f(0.2f, 1.2f, -0.01f));
        qa.setCoordinate(27, new Point3f(0.1f, 1.2f, -0.01f));

        return qa;
    }

    public static TriangleFanArray getTree() {
        int counts[] = {19};


        TriangleFanArray tfa = new TriangleFanArray(19,
                GeometryArray.COORDINATES
                | GeometryArray.COLOR_3,
                counts);

        tfa.setCoordinate(0, new Point3f(0.00f, 0.60f, 0.0f));
        tfa.setCoordinate(1, new Point3f(-0.05f, 0.00f, 0.0f));
        tfa.setCoordinate(2, new Point3f(0.05f, 0.00f, 0.0f));
        tfa.setCoordinate(3, new Point3f(0.05f, 0.25f, 0.0f));
        tfa.setCoordinate(4, new Point3f(0.15f, 0.30f, 0.0f));
        tfa.setCoordinate(5, new Point3f(0.22f, 0.25f, 0.0f));
        tfa.setCoordinate(6, new Point3f(0.18f, 0.40f, 0.0f));
        tfa.setCoordinate(7, new Point3f(0.20f, 0.55f, 0.0f));
        tfa.setCoordinate(8, new Point3f(0.15f, 0.65f, 0.0f));
        tfa.setCoordinate(9, new Point3f(0.14f, 0.80f, 0.0f));
        tfa.setCoordinate(10, new Point3f(0.08f, 0.95f, 0.0f));
        tfa.setCoordinate(11, new Point3f(0.00f, 1.00f, 0.0f));
        tfa.setCoordinate(12, new Point3f(-0.20f, 0.85f, 0.0f));
        tfa.setCoordinate(13, new Point3f(-0.22f, 0.70f, 0.0f));
        tfa.setCoordinate(14, new Point3f(-0.30f, 0.60f, 0.0f));
        tfa.setCoordinate(15, new Point3f(-0.35f, 0.45f, 0.0f));
        tfa.setCoordinate(16, new Point3f(-0.25f, 0.43f, 0.0f));
        tfa.setCoordinate(17, new Point3f(-0.30f, 0.25f, 0.0f));
        tfa.setCoordinate(18, new Point3f(-0.02f, 0.24f, 0.0f));
        return tfa;
    }

    public static Shape3D getTrees() {

        TriangleFanArray tfa = getTree();

        Color3f c = new Color3f(0.1f, 0.9f, 0.0f);
        for (int i = 0; i < 19; i++)
            tfa.setColor(i, c);
        c.set(0.5f, 0.5f, 0.3f);
        tfa.setColor(1, c);
        tfa.setColor(2, c);
        tfa.setColor(18, c);
        return new Shape3D(tfa);
    }

    public static Shape3D getHouses() {

        QuadArray qa = getHouse();

        Color3f c = new Color3f(1f, 1f, 1f);
        Color3f d = new Color3f(0f, 0f, 0f);
        Color3f e = new Color3f(1f, 0f, 0f);
        for (int i = 0; i < 4; i++)
            qa.setColor(i, c);
        for (int i = 4; i < 24; i++)
            qa.setColor(i, d);
        for (int i = 24; i < 28; i++)
            qa.setColor(i, e);

        Shape3D house = new Shape3D(qa);
        return house;
    }

    public static BranchGroup getTreeBranchGroup() {
        BranchGroup bg = getReadWriteBranchGroup();
        BoundingSphere bs = new BoundingSphere();
        bs.setRadius(10);
        SharedGroup share = new SharedGroup();
        share.addChild(getTrees());

        float position[][] = {{0.0f, 0f, -3.0f},
                              {6.0f, 0f, 0.0f},
                              {6.0f, 0f, 6.0f},
                              {3.0f, 0f, -10.0f},
                              {13.0f, 0f, -30.0f},
                              {-13.0f, 0f, 30.0f},
                              {-13.0f, 0f, 23.0f},
                              {13.0f, 0f, 3.0f}};

        Vector3f translate = new Vector3f();
        Transform3D t3D = new Transform3D();
        TransformGroup TGT;
        TransformGroup TGR;
        Billboard billboard;
        for (int i = 0; i < position.length; i++) {
            translate.set(position[i]);
            t3D.setTranslation(translate);
            TGT = new TransformGroup(t3D);
            TGR = new TransformGroup();
            TGR.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
            billboard = new Billboard(TGR);
            billboard.setSchedulingBounds(bs);
            billboard.setAlignmentMode(Billboard.ROTATE_ABOUT_POINT);
            bg.addChild(TGT);
            bg.addChild(billboard);
            TGT.addChild(TGR);
            TGR.addChild(new Link(share));
        }
        return bg;
    }

    public static BranchGroup getReadWriteBranchGroup() {
        BranchGroup bg = new BranchGroup();
        bg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        bg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        return bg;
    }

    public static BranchGroup getHousesBranchGroup() {
        BranchGroup bg = getReadWriteBranchGroup();
        BoundingSphere bs = new BoundingSphere();
        bs.setRadius(10);
        Vector3f translate = new Vector3f();
        Transform3D t3d = new Transform3D();
        SharedGroup sg = new SharedGroup();

        sg.addChild(getHouses());

        float position[][] = {{0.0f, 0f, -2.0f},
                              {3.0f, 0f, 0.0f},
                              {3.0f, 0f, 4.0f},
                              {4.0f, 0f, -8.0f},
                              {6.0f, 0f, -25.0f},
                              {-6.0f, 0f, 25.0f},
                              {-6.0f, 0f, 15.0f},
                              {6.0f, 0f, 1.0f}};

        TransformGroup TGT;
        TransformGroup TGR;
        Billboard billboard;
        for (int i = 0; i < position.length; i++) {
            translate.set(position[i]);
            t3d.setTranslation(translate);
            TGT = new TransformGroup(t3d);
            TGR = new TransformGroup();
            TGR.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
            billboard = new Billboard(TGR);
            billboard.setSchedulingBounds(bs);
            billboard.setAlignmentMode(Billboard.ROTATE_ABOUT_POINT);
            bg.addChild(TGT);
            bg.addChild(billboard);
            TGT.addChild(TGR);
            TGR.addChild(new Link(sg));
        }
        return bg;
    }

    public static Locale getLocale(View myView) {

        //First, we create the necessary coordinate systems
        //(VirtualUniverse, Locale), container nodes
        //(BranchGroup, TransformGroup), and platform which
        //determines our viewing position and direction (ViewPlatform).
        VirtualUniverse myUniverse = new VirtualUniverse();
        Locale myLocale = new Locale(myUniverse);
        BranchGroup myBranchGroup = new BranchGroup();
        TransformGroup myTransformGroup = new TransformGroup();
        ViewPlatform myViewPlatform = new ViewPlatform();

        //Next, we insert the platform into the transform group,
        //the transform group into the branch group, and the branch
        //group into the locale's branch graph portion of the
        //scene graph.
        myTransformGroup.addChild(myViewPlatform);
        myBranchGroup.addChild(myTransformGroup);
        myLocale.addBranchGraph(myBranchGroup);

        //Finally, we attach our view to the view platform and we
        //return a reference to our new universe.  We are ready to
        //render 3D content!
        myView.attachViewPlatform(myViewPlatform);
        return (myLocale);
    }

    public static View constructView(Canvas3D myCanvas3D) {
        View myView = new View();
        myView.addCanvas3D(myCanvas3D);
        myView.setPhysicalBody(new PhysicalBody());
        myView.setPhysicalEnvironment(new PhysicalEnvironment());
        return (myView);
    }

    public static void addTextToLocale(Locale myLocale) {
        //We first create a regular 2D font, then from that a
        //3D font, 3D text, and 3D shape, in succession.  We use
        //the default constructors for FontExtrusion and Appearance.
        Font myFont = new Font("TimesRoman", Font.PLAIN, 10);
        Font3D myFont3D = new Font3D(myFont, new FontExtrusion());
        Text3D myText3D = new Text3D(myFont3D, "The Midterm begins");
        Shape3D myShape3D = new Shape3D(myText3D, new Appearance());

        //We created a new branch group and transform group to hold
        //our content.  This time when we create the transform group,
        //however, we pass in a Transform3D to the transform group's
        //constructor.  This 3D transform has been manipulated
        //to perform the transformations we desire, which results
        //in those manipulations being carried out on all children
        //of the given transform group, in this case, our content.
        BranchGroup contentBranchGroup = new BranchGroup();
        Transform3D myTransform3D = new Transform3D();
        myTransform3D.setTranslation(new Vector3f(-2.0f, 0.0f, -4.0f));
        myTransform3D.setScale(0.1);
        Transform3D tempTransform3D = new Transform3D();
        tempTransform3D.rotY(Math.PI / 4.0d);
        myTransform3D.mul(tempTransform3D);
        TransformGroup contentTransformGroup = new TransformGroup(myTransform3D);

        //We add our child nodes and insert the branch group into
        //the live scene graph.  This results in Java 3D rendering
        //the content.
        contentTransformGroup.addChild(myShape3D);
        contentBranchGroup.addChild(contentTransformGroup);
        myLocale.addBranchGraph(contentBranchGroup);
    }

    public static BranchGroup getBackgroundBranchGroup() {
        // create a parent BranchGroup for the Background
        BranchGroup backgroundGroup = new BranchGroup();

        // create a new Background node
        Background back = new Background();

        // set the range of influence of the background
        back.setApplicationBounds(new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000.0));

        // create a BranchGroup that will hold
        // our Sphere geometry
        BranchGroup bgGeometry = new BranchGroup();

        // create the Sphere geometry with radius 1.0
        // we tell the Sphere to generate texture coordinates
        // to enable the texture image to be rendered
        // and because we are *inside* the Sphere we have to generate
        // Normal coordinates inwards or the Sphere will not be visible.
        Appearance appearance = new Appearance();
        appearance.setTexture(Utils.getMandleTexture(640, 480));
        Sphere sphere = new Sphere(.50f,
                Primitive.GENERATE_TEXTURE_COORDS |
                Primitive.GENERATE_NORMALS_INWARD,
                appearance);

        // start wiring everything together
        // add the Sphere to its parent BranchGroup
        bgGeometry.addChild(sphere);


        // assign the BranchGroup to the Background as geometry.
        back.setGeometry(bgGeometry);

        // add the Background node to its parent BranchGroup
        backgroundGroup.addChild(back);

        return backgroundGroup;
    }

    public static TransformGroup getReadWriteTransformGroup() {
        TransformGroup tg = new TransformGroup();
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        return tg;
    }

    public static BranchGroup getGunBranchGroup(TransformGroup gunTransformGroup) {
        BranchGroup theGun = new BranchGroup();

        Appearance gunApp = getGunAppearance();
        TransformGroup init = new TransformGroup();

        Transform3D gunXfm = new Transform3D();

        Matrix3d gunXfmMat = new Matrix3d();
        gunXfmMat.rotX(Math.PI / 2);
        gunXfm.set(gunXfmMat, new Vector3d(0.0, 0.0, 0.0), 1.0);
        init.setTransform(gunXfm);
        gunTransformGroup.addChild(new Box(1.0f, 1.0f, 0.5f, gunApp));
        gunTransformGroup.addChild(getBarrel(gunApp));
        theGun.addChild(init);
        init.addChild(gunTransformGroup);
        return theGun;
    }

    public static Appearance getGunAppearance() {
        Color3f ambientColour = new Color3f(0.5f, 0.5f, 0.5f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(0.5f, 0.5f, 0.5f);
        float shininess = 20.0f;
        Appearance gunApp = new Appearance();
        gunApp.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));
        return gunApp;
    }

    public static PlatformGeometry getBarrelPlatformGeometry() {
        PlatformGeometry pg = new PlatformGeometry();
        pg.addChild(Target.getTargetGroup());
        return pg;
    }

    public static TransformGroup getBarrel() {
        return getBarrel(getGunAppearance());
    }

    public static TransformGroup getBarrel(Appearance gunApp) {
        TransformGroup barrelTransformGroup = new TransformGroup();
        Transform3D barrelXfm = new Transform3D();
        barrelXfm.set(new Vector3d(0.0, -2.0, 0.0));
        barrelTransformGroup.setTransform(barrelXfm);
        barrelTransformGroup.addChild(new Cylinder(0.3f, 4.0f, gunApp));
        return barrelTransformGroup;
    }

    /**
     * This builds the view branch of the scene graph.
     *
     * @return BranchGroup with viewing objects attached.
     */
    public static BranchGroup buildViewBranch(Canvas3D c) {
        Matrix3d viewTiltMatrix3D = new Matrix3d();
        viewTiltMatrix3D.rotX(Math.PI / -6);

        Transform3D viewTransform3D = new Transform3D();

        viewTransform3D.set(viewTiltMatrix3D, new Vector3d(0.0, 10.0, 10.0), 1.0);
        TransformGroup viewTransformGroup
                = new TransformGroup(viewTransform3D);
        viewTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        viewTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

        ViewPlatform myViewPlatform = new ViewPlatform();
        PhysicalBody myPhysicalBody = new PhysicalBody();
        PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
        viewTransformGroup.addChild(myViewPlatform);
        BranchGroup viewBranchGroup = new BranchGroup();
        viewBranchGroup.addChild(getKeyNavigatorBehavior(viewTransformGroup));
        viewBranchGroup.addChild(viewTransformGroup);
        View myView = new View();
        myView.addCanvas3D(c);
        myView.attachViewPlatform(myViewPlatform);
        myView.setPhysicalBody(myPhysicalBody);
        myView.setPhysicalEnvironment(myEnvironment);
        return viewBranchGroup;
    }

    private static KeyNavigatorBehavior getKeyNavigatorBehavior(TransformGroup viewXfmGroup) {
        KeyNavigatorBehavior knb = new KeyNavigatorBehavior(viewXfmGroup);
        knb.setSchedulingBounds(new BoundingSphere());
        return knb;
    }
}
