package j3d.utils;

import classUtils.putils.ClassPathUtils;
import futils.Futil;
import gui.In;
import net.web.UrlUtils;
import utils.OsUtils;
import utils.SystemUtils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 5, 2005
 * <p/>
 * Time: 6:38:19 PM
 */
public class NativeLoadingTransporter {
    public static void load() {
        System.out.println("Loading java 3d for:" + OsUtils.getOsName());
        System.out.println("java.library.path=" +
                utils.SystemUtils.getLibraryPath());

        ///System/Library/Java/Extensions
        do
            if (load3dNativeLibs())
                return;
        while (In.getBoolean("try loading again?"));
    }

    private static boolean load3dNativeLibs() {
        if (OsUtils.isMacOs())
            return macOsLoad();
        else if (OsUtils.isWindows())
            return windowsOsLoad();
        return false;
    }

    private static boolean windowsOsLoad() {
        String libs[] = {
            "j3daudio", "J3D", "J3DUtils"
        };
        String fileNames[] = getWindowsFileNames(libs);

        return beamOverFiles(fileNames, libs);


    }

    private static boolean macOsLoad() {
        String libs[] = {
            "J3DAudio", "J3DUtils", "J3D"
        };
        String fileNames[] = getMacFileNames(libs);
        return beamOverFiles(fileNames, libs);
    }


    private static boolean beamOverFiles(String[] fileNames,
                                         String[] libs) {
        if (isInLibraryPath(fileNames)) {
            loadLibs(libs);
            return true;
        } else
            beamOverFiles(fileNames);
        return false;
    }


    private static URL[] getUrls(String fileNames[]) {
        String rootDir =
                "http://show.docjava.com:8086/book/cgij/code/jnlp/native/";
        if (OsUtils.isWindows())
            rootDir = rootDir + "windows/";
        if (OsUtils.isMacOs())
            rootDir = rootDir + "macosx/";
        URL urls[] = new URL[fileNames.length];
        for (int i = 0; i < fileNames.length; i++)
            try {
                urls[i] = new URL(rootDir + fileNames[i]);
                System.out.println(urls[i]);
            } catch (MalformedURLException e) {
                In.message(e);

            }
        return urls;
    }

    private static boolean isInLibraryPath(String[] fileNames) {

        String paths[] = ClassPathUtils.getLibraryPaths();
        for (int i = 0; i < fileNames.length; i++) {
            if (isInPaths(paths, fileNames[i]))
                continue;
            else
                return false;

        }
        return true;
    }

    private static boolean isInPaths(String paths[], String fileName) {
        for (int i = 0; i < paths.length; i++) {
            File f = new File(paths[i] +
                    SystemUtils.getDirectorySeparator() +
                    fileName);
            System.out.println("checking:" + f.getAbsolutePath());
            if (f.exists()) return true;
        }
        return false;
    }

    private static void beamOverFiles(String files[]) {
        if (!In.getBoolean("files are not in load path! " +
                "Would you like to beam them over?"))
            return;
        String paths[] = ClassPathUtils.getLibraryPaths();
        String selection = (String)
                In.multiPrompt(paths, "where do you want them?",
                        "destination dialog");

        for (int i = 0; i < files.length; i++)
            System.out.println(files[i]);
        URL urls[] = getUrls(files);
        for (int i = 0; i < files.length; i++) {
            byte b[] = UrlUtils.getUrlBytes(urls[i]);
            File f = new File(selection +
                    SystemUtils.getDirectorySeparator() +

                    files[i]);
            if (f.exists())
                if (!In.getBoolean("file:" + f + "exists! continue?"))
                    System.exit(0);

            Futil.writeBytes(f, b);

        }
    }

    private static void loadLibs(String libs[]) {
        for (int i = 0; i < libs.length; i++)
            System.loadLibrary(libs[i]);
        In.message("loaded libs!");
    }

    private static String[] getWindowsFileNames(String[] libs) {
        String fileNames[] = new String[libs.length];
        for (int i = 0; i < libs.length; i++) {

            fileNames[i] =
                    libs[i] +
                    ".dll";
        }
        return fileNames;
    }

    private static String[] getMacFileNames(String[] libs) {
        String fileNames[] = new String[libs.length];
        for (int i = 0; i < libs.length; i++) {
            fileNames[i] = "lib" +
                    libs[i] +
                    ".jnilib";
        }
        return fileNames;
    }

    public static void main(String[] args) {
        load();
    }
}
