package j3d.utils;

/*
      @(#)Color4fEditor.java 1.2 01/08/01 11:02:11

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import gui.run.FloatEvent;
import gui.run.FloatLabelJSlider;
import gui.run.FloatListener;

import javax.swing.*;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;


public class Color4fEditor extends Box implements ActionListener,
        Java3DExplorerConstants {

    String name;
    Color4f color = new Color4f();
    Color3f color3f = new Color3f(); // just RGB of Color4f
    JButton button;
    JPanel preview;
    Vector listeners = new Vector();

    public Color4fEditor(String initName, Color4f initColor) {
        super(BoxLayout.Y_AXIS);
        name = initName;
        color.set(initColor);
        color3f.x = color.x;
        color3f.y = color.y;
        color3f.z = color.z;

        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BorderLayout());
        add(colorPanel);

        JLabel label = new JLabel(name);

        preview = new JPanel();
        preview.setPreferredSize(new Dimension(40, 40));
        preview.setBackground(color3f.get());
        preview.setBorder(BorderFactory.createRaisedBevelBorder());

        button = new JButton("Set");
        button.addActionListener(this);

        JPanel filler = new JPanel();
        filler.setPreferredSize(new Dimension(100, 20));

        Box box = new Box(BoxLayout.X_AXIS);
        colorPanel.add(box, BorderLayout.WEST);

        box.add(label);
        box.add(preview);
        box.add(button);
        box.add(filler);

        FloatLabelJSlider alphaSlider = new FloatLabelJSlider("    Alpha");
        alphaSlider.setValue(color.w);
        alphaSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent event) {
                color.w = event.getValue();
                valueChanged();
            }
        });
        add(alphaSlider);
    }

    public void actionPerformed(ActionEvent e) {
        Color currentColor = color3f.get();
        Color newColor = JColorChooser.showDialog(this, name, currentColor);
        if (newColor != null) {
            color3f.set(newColor);
            color.x = color3f.x;
            color.y = color3f.y;
            color.z = color3f.z;
            valueChanged();
        }
    }

    public void setValue(Color4f newValue) {
        boolean changed = !color.equals(newValue);
        if (changed) {
            color.set(newValue);
            color3f.x = color.x;
            color3f.y = color.y;
            color3f.z = color.z;
            valueChanged();
        }
    }

    public void addColor4fListener(Color4fListener listener) {
        listeners.add(listener);
    }

    public void removeColor4fListener(Color4fListener listener) {
        listeners.remove(listener);
    }

    private void valueChanged() {
        // update the preview
        preview.setBackground(color3f.get());

        // notify the listeners
        Color4fEvent event = new Color4fEvent(this, color);
        for (Enumeration e = listeners.elements(); e.hasMoreElements();) {
            Color4fListener listener = (Color4fListener) e.nextElement();
            listener.colorChanged(event);
        }
    }
}
