package j3d.utils;

/*
      @(#)Color3fEditor.java 1.2 01/08/01 11:02:10

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import javax.swing.*;
import javax.vecmath.Color3f;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;


public class Color3fEditor extends JPanel implements ActionListener,
        Java3DExplorerConstants {

    String name;
    Color3f color = new Color3f();
    JButton button;
    JPanel preview;
    Vector listeners = new Vector();

    public Color3fEditor(String initName, Color3f initColor) {
        name = initName;
        color.set(initColor);

        JLabel label = new JLabel(name);

        preview = new JPanel();
        preview.setPreferredSize(new Dimension(40, 40));
        preview.setBackground(color.get());
        preview.setBorder(BorderFactory.createRaisedBevelBorder());

        button = new JButton("Set");
        button.addActionListener(this);

        JPanel filler = new JPanel();
        filler.setPreferredSize(new Dimension(100, 20));

        setLayout(new BorderLayout());
        Box box = new Box(BoxLayout.X_AXIS);
        add(box, BorderLayout.WEST);

        box.add(label);
        box.add(preview);
        box.add(button);
        box.add(filler);

    }

    public void actionPerformed(ActionEvent e) {
        Color currentColor = color.get();
        Color newColor = JColorChooser.showDialog(this, name, currentColor);
        if (newColor != null) {
            color.set(newColor);
            valueChanged();
        }
    }

    public void setValue(Color3f newValue) {
        boolean changed = !color.equals(newValue);
        if (changed) {
            color.set(newValue);
            valueChanged();
        }
    }

    public void addColor3fListener(Color3fListener listener) {
        listeners.add(listener);
    }

    public void removeColor3fListener(Color3fListener listener) {
        listeners.remove(listener);
    }

    private void valueChanged() {
        // update the preview
        preview.setBackground(color.get());

        // notify the listeners
        Color3fEvent event = new Color3fEvent(this, color);
        for (Enumeration e = listeners.elements(); e.hasMoreElements();) {
            Color3fListener listener = (Color3fListener) e.nextElement();
            listener.colorChanged(event);
        }
    }
}
