//Byron Kim
/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.polyViewer.vec3;

public class Tubular implements Vec3FunctionInterface {
    public static final double sqrt_2 = Math.sqrt(2);
    public static final double pi = Math.PI;
    public static final double twoPi = Math.PI * 2;

    public Tubular() {

    }

    public Vec3 getPolarVec3(double r1,
                             double theta1,
                             double r2,
                             double theta2) {


        double x, y, z;

        double r = 1;
        x = r * cos(theta1);

        y = r * sin(theta1);
        // Byron: r=f(z,theta) and z is = f(theta2)
        // let theta2 range from 0 to height of image
        // you need to build an array of radii like in
        // TopFrame.java
        z = theta2/twoPi;
        //double scale = twoPi * r2 * r2;
        //z = z * scale;
        return new Vec3(
                (float) x,
                (float) y,
                (float) z);

    }

    private double scale(double t, double tmin, double tmax) {
        t = (1 - t) * tmin + t * tmax;
        return t;
    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
