/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.polyViewer.vec3;

import ip.transforms.Kernels;


/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 2, 2005
 * <p/>
 * Time: 4:02:56 AM
 */
public class GaborCos implements Vec3FunctionInterface {
    public static final double sqrt_2 = Math.sqrt(2);
    public static final double pi = Math.PI;
    public static final double twoPi = Math.PI * 2;

    public GaborCos() {

    }

    public Vec3 getPolarVec3(double r1,
                             double theta1,
                             double r2,
                             double theta2) {

        //
        double x, y, z;
        // theta's fall out of n's  as gemetric indices to points in the
        //      array of samples.
        // this determines spacing of triangles and assures no scale
        //  change in x to result from sampling size
        // r1 is therefore the range.


        //x = scale(theta1 / twoPi, -r1, r1);
        //y = scale(theta2 / twoPi, -r2, r2);
        x = scale(theta1 / twoPi, -1, 1);
        y = scale(theta2 / twoPi, -1, 1);
        // r2 is sigma
        // r1 is ripple
        z = Kernels.gauss(x, y, 0, 0, r2) * cos(x*(r1-.22)*40);
        // Gauss's peak drops by sigma-squared
        double scale = twoPi * r2 * r2;
        z = z * scale;

        return new Vec3((float) x,
                (float) y,
                (float) z);

    }

    private double scale(double t, double tmin, double tmax) {
        t = (1 - t) * tmin + t * tmax;
        return t;
    }

    //? Why are these public?  And why not use Math.sin?
    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
