package j3d.polyViewer.vec3;

import ip.transforms.Kernels;

/**
 * Created by IntelliJ IDEA.
 * User: nishanth
 * Date: Apr 11, 2005
 * Time: 6:50:39 PM
 * To change this template use File | Settings | File Templates.
 */
public class EllipticParaboloid implements Vec3FunctionInterface {


    public static final double sqrt_2 = Math.sqrt(2);
    public static final double pi = Math.PI;
     public static final double twoPi = Math.PI * 2;


    public EllipticParaboloid()
    {}

    public Vec3 getPolarVec3(double r1, double theta1, double r2, double theta2) {
        double x, y, z;
              x = -2;
              x = scale(theta1 / twoPi, -r1, r1);

            y = -Math.sqrt(4-x*x);

              y = scale(theta2 / twoPi, -r1, r1);

              try {

                 z = (x*x + y*y);
                 z = scale(z, -r1, r1);
              } catch (Exception e) {
                  z = 0;

              }
              return new Vec3((float) x,
                      (float) y,
                      (float) z);
    }

          private double scale(double t, double tmin, double tmax) {
        t = (1 - t) * tmin + t * tmax;
        return t;
    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }


}
