package j3d.polyViewer;

/**
 CSE391 demo. Uses Java3D to view a list of triangles, to show
 how dynamically generated object can be controlled and displayed.
 Adapted from Sun's GearTest example, by GWH, Sept 2003, but object
 is a simple torus with structure determined by GUI controls.
 */

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import gui.ClosableJFrame;
import gui.run.RunMenuBar;
import j3d.examples.keyboardNavigate.CollisionDetector;
import j3d.examples.keyboardNavigate.KeyCollisionBehavior;

import javax.media.j3d.*;
import javax.swing.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import java.awt.*;

public class PolyFrame extends ClosableJFrame {



    private SimpleUniverse su = null;
    private RunShapePanel rsp = new RunShapePanel() {
        public void run() {
            updateShape();
        }
    };

    private BranchGroup objSplice;
    // where our thing gets spliced into scene
    private BranchGroup objBranch;
    // group containing our thing

    public PolyFrame() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);

        // create control panel in separate JFrame
        rsp.showInFrame();
        setMenuBar();
        // put 3D canvas in this frame
        Container cont = getContentPane();
        cont.setLayout(new BorderLayout());
        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        cont.add("Center", c);

        // Create a simple scene and attach it to the virtual universe
        BranchGroup scene = createSceneGraph();
        su = new SimpleUniverse(c);
        orbitControls(c);
        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        su.getViewingPlatform().setNominalViewingTransform();

        su.addBranchGraph(scene);
    }
    private void orbitControls(Canvas3D c) {
        OrbitBehavior orbit =
                new OrbitBehavior(c, OrbitBehavior.REVERSE_ALL);
        orbit.setSchedulingBounds(getFrameBounds());

        ViewingPlatform vp = su.getViewingPlatform();

        vp.setViewPlatformBehavior(orbit);
    }

    public void setMenuBar() {
        RunMenuBar mb = new RunMenuBar();
        mb.add(rsp.getFileMenu());
        mb.add(rsp.getShapeMenu());
        setJMenuBar(mb);
    }




    // Create our scene graph, with lights, rotation, and object
    public BranchGroup createSceneGraph() {
        // Create the root of the branch graph
        BranchGroup objRoot = new BranchGroup();

        // Create a Transformgroup to scale all objects so they
        // appear in the scene.
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.6);
        objScale.setTransform(t3d);
        objRoot.addChild(objScale);

        // Create a bounds for the background and lights
        BoundingSphere bounds = getFrameBounds();

        setBackgroundColor(bounds, objScale);
        setupGlobalLights(bounds, objScale);
        TransformGroup objTrans = setUpwritableTransformGroup(objScale);


        // first as list of triangles
        Shape3D thing = rsp.getShape3D();
        initObjectSplice();
        objBranch = new BranchGroup();
        objBranch.setCapability(BranchGroup.ALLOW_DETACH);
        objTrans.addChild(objSplice);
        objSplice.addChild(objBranch);
        objBranch.addChild(thing);

        objTrans.addChild(getRotationInterpolator(objTrans));
        // todo make a view property panel that lets
        // you set your coordinate frame
        //objRoot.addChild(new CheckerFloor().getBG());
        return objRoot;
    }

    private RotationInterpolator getRotationInterpolator(TransformGroup objTrans) {
        // Create a new Behavior object that will rotate the object and
        // add it into the scene graph.
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE,
                0, 0,
                4000, 0, 0,
                0, 0, 0);
        RotationInterpolator rotator =
                new RotationInterpolator(rotationAlpha, objTrans, yAxis,
                        0.0f, (float) Math.PI * 2.0f);
        BoundingSphere bounds =
                new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds(bounds);
        return rotator;
    }

    private void getViewTransformGroup(TransformGroup tg) {
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.5);
        t3d.invert();
        tg.setTransform(t3d);
        // do key junk
        // create the KeyBehavior and attach
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        CollisionDetector cd = new CollisionDetector(){
            public boolean isCollision(Transform3D t3d, boolean bViewSide){
                return false;
            }
        };
        KeyCollisionBehavior keyBehavior = new KeyCollisionBehavior(tg,cd);
        keyBehavior.setSchedulingBounds(PolyFrame.getFrameBounds());
        keyBehavior.setMovementRate(0.7);
        tg.addChild(keyBehavior);
    }

    private static BoundingSphere getFrameBounds() {
        BoundingSphere bounds =
                new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        return bounds;
    }

    private static TransformGroup setUpwritableTransformGroup(TransformGroup objScale) {
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        objScale.addChild(objTrans);
        return objTrans;
    }

    private void setupGlobalLights(BoundingSphere bounds,
                                   TransformGroup objScale) {
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(4.0f, -7.0f, -12.0f);
        Color3f light2Color = new Color3f(0.3f, 0.3f, 0.4f);
        Vector3f light2Direction = new Vector3f(-6.0f, -2.0f, -1.0f);
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);

        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds(bounds);
        objScale.addChild(ambientLightNode);

        DirectionalLight light1
                = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds(bounds);
        objScale.addChild(light1);

        DirectionalLight light2 = new DirectionalLight(light2Color,
                light2Direction);
        light2.setInfluencingBounds(bounds);
        objScale.addChild(light2);
    }

    private void setBackgroundColor(BoundingSphere bounds,
                                    TransformGroup objScale) {
        Color3f bgColor = new Color3f(0.95f, 0.9f, 0.4f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds(bounds);
        objScale.addChild(bgNode);
    }



    private void initObjectSplice() {
        objSplice = new BranchGroup();
        objSplice.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
        objSplice.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
    }

    public void updateShape() {
        Shape3D shape = rsp.getShape3D();
        BranchGroup newBG = new BranchGroup();
        newBG.setCapability(BranchGroup.ALLOW_DETACH);
        newBG.addChild(shape);
        replaceBranch(newBG);
    }

    private void replaceBranch(BranchGroup newBranch) {
        objBranch.detach();
        // remove old one
        objBranch = newBranch;

        objSplice.addChild(objBranch);
        // splice in new one
    }

    // when all done...
    public void destroy() {
        su.cleanup();
    }

    public static void main(String[] args) {
        PolyFrame polyFrame = new PolyFrame();
        polyFrame.setSize(400, 400);
        polyFrame.setVisible(true);
    }
}
