package j3d.examples.shape.triangles.surfaces.geometries;

import j3d.examples.shape.triangles.surfaces.SurfaceGeometry;
import j3d.examples.shape.triangles.surfaces.SurfaceUniverse;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import java.awt.*;

public class NestedBowls extends SurfaceGeometry {

    public NestedBowls(int strips, int stripLength, Color3f c1, Color3f c2) {
        super(strips, stripLength, c1, c2);
    }

    public Vector3d getViewingPosition() {
        return new Vector3d(0, 0, 10);
    }

    public double distance(int strip, int index, int segment) {
        double x = x(strip, index, segment);
        double z = z(strip, index, segment);
        return Math.sqrt(x * x + z * z);
    }

    public static void main(String[] args) {
        new SurfaceUniverse("Nested Bowls",
                new NestedBowls(50, 25,
                        new Color3f(Color.yellow),
                        new Color3f(Color.black)));
    }

    public double radius(int strip, int segment) {
        // This version makes the outside of the bowl opaque
//    return (strip + 1 - segment)/(double)strips;
        // This version makes the inside of the bowl opaque
        return 3 * (strip + segment) / (double) strips;
    }

    public double x(int strip, int index, int segment) {
        return radius(strip, segment) * Math.sin(radians(index));
    }

    public double y(int strip, int index, int segment) {
        double distance = distance(strip, index, segment);
        // The factor of 4.5 makes it come out even.
        return Math.sin(distance * Math.PI * 4.5);
    }

    public double z(int strip, int index, int segment) {
        return radius(strip, segment) * Math.cos(radians(index));
    }

}