package j3d.examples.shape.cube;


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import java.applet.Applet;
import java.awt.*;

//   HelloJava3Db renders a single, rotated cube.

public class StillTilted extends Applet {
    public BranchGroup getBranchGraph() {
        // Create the root of the branch graph
        BranchGroup bg = new BranchGroup();

        // rotate object has composited transformation matrix
        Transform3D rotx = new Transform3D();
        Transform3D roty = new Transform3D();
        Transform3D rotz = new Transform3D();

        rotx.rotX(Math.PI / 4.0d);
        roty.rotY(Math.PI / 5.0d);
        rotz.rotZ(Math.PI / 2.0d);
        rotx.mul(roty);
        rotx.mul(rotz);

        TransformGroup tg = new TransformGroup(rotx);

        bg.addChild(tg);
        tg.addChild(new ColorCube(0.4));
        // Let Java 3D perform optimizations on this scene graph.
        bg.compile();

        return bg;
    } // end of CreateSceneGraph method of HelloJava3Db

    // Create a simple scene and attach it to the virtual universe

    public StillTilted() {
        setLayout(new BorderLayout());
        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();

        Canvas3D canvas3D = new Canvas3D(config);
        add("Center", canvas3D);

        BranchGroup bg = getBranchGraph();

        // SimpleUniverse is a Convenience Utility class
        SimpleUniverse simpleU = new SimpleUniverse(canvas3D);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        simpleU.getViewingPlatform().setNominalViewingTransform();

        simpleU.addBranchGraph(bg);
    }

    public static void main(String[] args) {
        new MainFrame(new StillTilted(), 256, 256);
    } // end of main (method of HelloJava3Db)

} // end of class HelloJava3Db
