/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.examples.color;

// Checkers3D.java
// Andrew Davison, January 2003, dandrew@ratree.psu.ac.th

/* A simple basic world consisting of a checkboard floor, 
   with a red center square, and labelled XZ axes.

   A floating, shiny blue sphere is placed at the center.
*/

import gui.ClosableJFrame;
import gui.run.RunMenu;
import gui.run.RunMenuBar;
import gui.run.RunMenuItem;

import javax.swing.*;
import java.awt.*;

// use the checkers model to create a shape that is
// a 3d version of the shape that you were assigned for the midterm

public class Main extends ClosableJFrame {
    public Main() {
        super("Color 3d visualizer");
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        CheckerPanel cp = new CheckerPanel();
        Container c = getContentPane();
        setJMenuBar(getRunMenuBar(cp));
        c.setLayout(new BorderLayout());

        c.add(cp, BorderLayout.CENTER);
        pack();

        show();
    }

    public RunMenuBar getRunMenuBar(CheckerPanel cp) {
        RunMenuBar rmb = new RunMenuBar();
        rmb.add(getFileMenu(cp));
        return rmb;
    }

    RunMenu getFileMenu(final CheckerPanel cp) {
        RunMenu rm = new RunMenu("[File");
        rm.add(new RunMenuItem("Open Image") {
            public void run() {
                cp.openImage();
            }
        });
        return rm;

    }
// -----------------------------------------

    public static void main(String[] args) {
        new Main();
    }

} // end of Checkers3D class
