/*
 * Found at http://mrl.nyu.edu/~perlin/noise/
 *
 */
package j3d.examples.appearance.texture.noise;

// JAVA REFERENCE IMPLEMENTATION OF IMPROVED NOISE - COPYRIGHT 2002 KEN PERLIN.

public final class ImprovedNoise {
    static public double noise(double x, double y, double z) {
        int X = (int) Math.floor(x) & 255,
// FIND UNIT CUBE THAT
                Y = (int) Math.floor(y) & 255,
// CONTAINS POINT.
                Z = (int) Math.floor(z) & 255;
        x -= Math.floor(x);
// FIND RELATIVE X,Y,Z
        y -= Math.floor(y);
// OF POINT IN CUBE.
        z -= Math.floor(z);
        double u = fade(x),
// COMPUTE FADE CURVES
                v = fade(y),
// FOR EACH OF X,Y,Z.
                w = fade(z);
        int A = p[X] + Y, AA = p[A] + Z, AB = p[A + 1] + Z,
                // HASH COORDINATES OF
                B = p[X + 1] + Y, BA = p[B] + Z, BB = p[B + 1] + Z;
        // THE 8 CUBE CORNERS,

        return lerp(w, lerp(v, lerp(u, grad(p[AA], x, y, z),
                // AND ADD
                grad(p[BA], x - 1, y, z)),
                // BLENDED
                lerp(u, grad(p[AB], x, y - 1, z),
                        // RESULTS
                        grad(p[BB], x - 1, y - 1, z))),
                // FROM  8
                lerp(v, lerp(u, grad(p[AA + 1], x, y, z - 1),
                        // CORNERS
                        grad(p[BA + 1], x - 1, y, z - 1)),
                        // OF CUBE
                        lerp(u, grad(p[AB + 1], x, y - 1, z - 1),
                                grad(p[BB + 1], x - 1, y - 1, z - 1))));
    }

    static double fade(double t) {
        return t * t * t * (t * (t * 6 - 15) + 10);
    }

    static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    static double grad(int hash, double x, double y, double z) {
        int h = hash & 15;
        // CONVERT LO 4 BITS OF HASH CODE
        double u = h < 8 ? x : y,
                // INTO 12 GRADIENT DIRECTIONS.
                v = h < 4 ? y : h == 12 || h == 14 ? x : z;
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    static final int p[] = new int[512], permutation[] = {
        151, 160, 137, 91, 90, 15,
        131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23,
        190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33,
        88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166,
        77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244,
        102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196,
        135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123,
        5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42,
        223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9,
        129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228,
        251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107,
        49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254,
        138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180
    };

    static {
        for (int i = 0; i < 256; i++) p[256 + i] = p[i] = permutation[i];
    }


    /*
     * The code below this comment was added to the reference implementation.
     */

    /*
     * Reinitialize the permutation array based on a random number generator
     * seed.  The algorithm used to initialize this array is described in
     * "Texture & Modeling: A Procedural Approach", by David S. Ebert,
     * F. Kenton Musgrave, Darwyn Peachey, Ken Perlin, and
     * Steven Worley, Morgan Kaufmann Publishers, ISBN 1-55860-848-6.
     */
    static public void reinitialize() {
        reinitialize(System.currentTimeMillis());
    }

    static public void reinitialize(long seed) {
        java.util.Random generator = new java.util.Random(seed);

        for (int i = 0; i < 256; i++) {
            permutation[i] = i;
        }
        // Scramble the permutation contents to create a repeatable
        // "random" series of integers.
        for (int i = 0; i < 256; i++) {
            int j = generator.nextInt(255);
            int k = permutation[i];
            permutation[i] = permutation[j];
            permutation[j] = k;
        }

        // The p[] is twice as large as the permutation[] so
        // that a mod 256 need not be done to compute the wavelet
        // coefficients.
        for (int i = 0; i < 256; i++) {
            p[256 + i] = p[i] = permutation[i];
        }

    }

    /*
     * A fast implementation of fractional Brownian motion.
     * This implementation assumes an integer number of octaves and
     * a lacunarity of two.  This simplification is done for speed.
     */
    static public double fBm(double x,
                             double y,
                             double z,
                             int H,
                             int octaves) {
        double answer = 0;
        for (int i = 0; i < octaves; i++) {
            answer = answer + noise(x, y, z) / (1 << H * i);
            x = x * 2;
            y = y * 2;
            z = z * 2;
        }
        return answer;
    }

    /*
     * A simple implementation of turbulance.
     * This implementation assumes an integer number of octaves and
     * a lacunarity of two.  This simplification is done for speed.
     */
    static public double turbulance(double x,
                                    double y,
                                    double z,
                                    int octaves) {
        int frequency = 1;
        double t = 0;
        for (int octave = 0; octave < octaves; octave++) {
            t = t + Math.abs(noise(x, y, z)) / frequency;
            x = x * 2;
            y = y * 2;
            z = z * 2;
            frequency = frequency << 1;
        }
        return t;
    }

    /*
     * An implementation to support the generation of a wood grain.
     */
    static public double wood(double x, double y, double z) {
        double noise = noise(x, y, z) * 15.0;
        double grain = noise - Math.floor(noise);
        return grain;
    }

    /*
     * Based on the classic (circa 1985) Perlin
     * implementation for generating a marble pattern.
     */
    static public double marble(double x, double y, double z, int octaves) {
        double t = turbulance(x, y, z, octaves);
        double marble = Math.sin(y + t);
        return marble;
    }

    /*
     * A simple implementation of a ridged multifractal noise
     * function.  This implementation assumes an integer number
     * of octaves, a lacunarity of 2.0, and an H factor of 1.0.
     * This simplification is done for speed.
     */
    static public double ridged(double x,
                                double y,
                                double z,
                                int octaves,
                                double offset,
                                double gain) {
        double answer = 0;
        double signal;
        double weight = 1.0;
        int frequency = 1;

        for (int octave = 0; octave < octaves; octave++) {
            signal = offset - Math.abs(noise(x, y, z));
            // Square the signal to sharpen the ridges
            signal = signal * signal * weight;
            answer = answer + signal / frequency;
            // weight successive contributions by previous signal
            weight = signal * gain;
            // Clamp the weight 0..1
            if (weight > 1.0)
                weight = 1.0;
            if (weight < 0.0)
                weight = 0.0;
            x = x * 2;
            y = y * 2;
            z = z * 2;
            frequency = frequency << 1;
        }

        return answer;
    }
}
