/*
 * A simple behavior that notifies a listener when
 * the configured number of milliseconds has past.
 */
package j3d.examples.appearance.texture.noise;

import javax.media.j3d.*;
import java.awt.*;
import java.util.Enumeration;

public class ElapsedTimeBehavior extends Behavior {
    private WakeupCondition wakeupCondition = null;
    private IElapsedTimeListener listener;

    public ElapsedTimeBehavior(IElapsedTimeListener listener,
                               int milliseconds) {
        this.listener = listener;
        WakeupCriterion[] wakeupArray = new WakeupCriterion[1];
        wakeupArray[0] = new WakeupOnElapsedTime(milliseconds);
        wakeupCondition = new WakeupOr(wakeupArray);
    }

    public void initialize() {
        wakeupOn(wakeupCondition);
    }

    public void processStimulus(Enumeration criteria) {
        WakeupOnElapsedTime event;
        WakeupCriterion criterion;
        AWTEvent[] events;
        while (criteria.hasMoreElements()) {
            criterion = (WakeupCriterion) criteria.nextElement();
            if (criterion instanceof WakeupOnElapsedTime) {
                event = (WakeupOnElapsedTime) criterion;
                listener.tick();
            }
        }
        wakeupOn(wakeupCondition);
    }

}
