package j2d.rotator;

import futils.WriterUtil;
import gui.ClosableJFrame;
import gui.run.RunMenu;
import gui.run.RunMenuBar;
import gui.run.RunMenuItem;
import ip.ppm.WritePPM;
import j2d.ShortImageBean;

import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;

/**
 * Created by IntelliJ IDEA.
 * User: David Pavlik
 * Date: May 8, 2004
 * Time: 1:48:30 PM
 */
public class Main {
    private final AffineMediator affineMediator = new AffineMediator();
    private ClosableJFrame imageFrame;


    public Main() {
        affineMediator.getNewImage();
        imageFrame = getDisplayFrame();
    }
    public static void main(String[] args) {
        new Main();
    }

    private ClosableJFrame getDisplayFrame() {
        ClosableJFrame imageFrame = new ClosableJFrame();
        Container c = imageFrame.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(getMenuBar(), BorderLayout.NORTH);
        c.add(affineMediator.imagePanel, BorderLayout.CENTER);
        int w = affineMediator.image.getWidth(affineMediator.imagePanel);
        int h = affineMediator.image.getHeight(affineMediator.imagePanel);
        imageFrame.setSize(w * 2, h * 2);
        imageFrame.show();
        return imageFrame;
    }

    private JMenuBar getMenuBar() {
        RunMenuBar mb = new RunMenuBar();
        mb.add(getFileMenu());
        return mb;
    }

    private RunMenu getFileMenu() {
        RunMenu rm = new RunMenu("[File");
        rm.add(new RunMenuItem("[Open... {ctrl O}") {
            public void run() {
                imageFrame.dispose();
                initializeSettings();
                affineMediator.getNewImage();
                imageFrame = getDisplayFrame();
            }
        });
        JMenu saveAs = new JMenu("Save as... ");
        saveAs.setMnemonic(KeyEvent.VK_S);
        rm.add(saveAs);

        saveAs.add(new RunMenuItem("[GIF...(not 24 bit!)") {
            public void run() {
                saveAsGif();
            }
        });
        saveAs.add(new RunMenuItem("[PPM...") {
            public void run() {
                saveAsPPM();
            }
        });
        rm.add(new RunMenuItem("[Exit {ctrl E}") {
            public void run() {
                System.exit(0);
            }
        });

        return rm;
    }

    private void initializeSettings() {
        //setSlidersToZero();
        affineMediator.priorTransform = new AffineTransform();
    }

    private void saveAsGif() {
        String fn = WriterUtil.getSaveFileName("Save as GIF");
        if (fn == null) return;
        saveAsGif(fn);
    }

    private void saveAsGif(String fn) {
        try {
            ip.vs.WriteGIF.DoIt(affineMediator.image, fn + ".gif");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveAsPPM() {
        String fn = WriterUtil.getSaveFileName("Save as PPM");
        if (fn == null) return;
        saveAsPPM(fn);
    }

    private void saveAsPPM(String fn) {
        ShortImageBean shortImageBean = new ShortImageBean();
        shortImageBean.setImage(affineMediator.image);
        WritePPM.doIt(shortImageBean.getR(), shortImageBean.getG(), shortImageBean.getB(), fn + ".ppm");
    }
}

