package j2d.gui;

import bookExamples.ch26Graphics.draw2d.DrawComponent;
import gui.run.RunMenu;
import gui.run.RunMenuItem;
import ip.transforms.Kernels;
import j2d.ImageUtils;
import j2d.ShortImageBean;
import j2d.color.ColorizerPanel;
import j2d.edge.*;
import j2d.filters.GaussianPanel;
import j2d.hpp.*;
import j3d.polyViewer.PolyFrame;

import javax.swing.*;
import java.awt.*;


/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 24, 2005
 * Time: 2:34:13 PM
 * Copyright DocJava, 2005
 */
public class MainMenus {

    public static RunMenu getEdgeMenu(final Main main) {
        RunMenu rm = new RunMenu("[Edge");
        rm.add(getRobinsonMenu(main));
        rm.add(getLaplacianMenu(main));
        rm.add(new RunMenuItem("[hough") {
            public void run() {
                main.addPanel(new HoughPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("[Canny{alt ctrl c}") {
            public void run() {
                main.addPanel(new CannyPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("[LoGSobel{alt ctrl s}") {
            public void run() {
                main.addPanel(new LoGSobelPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("[MagDOG{alt ctrl d}") {
            public void run() {
                main.addPanel(new MagDOGPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("[Sobel{alt ctrl o}") {
            public void run() {
                main.addPanel(new SobelPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("MehrotraAnd[Zhang{alt ctrl z}") {
            public void run() {
                main.addPanel(new MehrotraAndZhangPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("[Template{alt ctrl t}") {
            public void run() {
                main.addPanel(new TemplatePanel(main), getText());
            }
        });//
        return rm;
    }

    public static RunMenu getBlurMenu(final Main main) {
        RunMenu rm = new RunMenu("[Blur");
        // to do add edge panels here
        rm.add(new RunMenuItem("[GaussianPanel{alt ctrl G}") {
            public void run() {
                GaussianPanel cp = new GaussianPanel(main);
                main.addPanel(cp, getText());
            }
        });
        rm.add(new RunMenuItem("[visualize 3d functions{alt ctrl v}") {
            public void run() {
                PolyFrame.main(null);
            }
        });
        return rm;
    }

    public static RunMenu getFilterMenu(final Main main) {
        RunMenu rm = new RunMenu("F[ilter");
        rm.add(getEdgeMenu(main));
        rm.add(getBlurMenu(main));

        rm.add(getHpMenu(main));
        rm.add(getLpMenu(main));
        rm.add(getMedianMenu(main));
        rm.add(getOtherTransformsMenu(main));
        rm.add(new RunMenuItem("BorderPanel") {
            public void run() {
                main.addPanel(new j2d.border.BorderPanel(main), getText());
            }
        });
        return rm;
    }

    public static RunMenu getHistogramMenu(final Main main) {
        RunMenu processMenu = new RunMenu("[Histogram");
        processMenu.add(new RunMenuItem("H[istogram Panel{ctrl i}") {
            public void run() {
                HistogramPanel cp = new HistogramPanel(main);
                main.addPanel(cp, getText());
            }
        });
        processMenu.add(new RunMenuItem("[Exponential Stretch") {
            public void run() {
                if (main.estStretchControls == null ||
                        main.estStretchControls.isClosed()) {
                    main.launchStretchControls();
                }
            }
        });
        processMenu.add(new RunMenuItem("[ContrastPanel{alt ctrl C}") {
            public void run() {
                ContrastPanel cp = new ContrastPanel(main);
                main.addPanel(cp, getText());
            }
        });

        return processMenu;
    }

    public static void addProcessMenu(final Main main, JMenuBar mb) {
        RunMenu processMenu = new RunMenu("[process");
        processMenu.add(getHistogramMenu(main));
        processMenu.add(ColorMenu.getColorMenu(main));
        processMenu.add(getFilterMenu(main));
        processMenu.add(getDrawMenu(main));
        mb.add(processMenu);
        processMenu.add(new RunMenuItem("[Apply{control A}") {
            public void run() {
                main.apply();
            }
        });
        processMenu.add(new RunMenuItem("GreyHppFilter3Panel") {
            public void run() {
                main.addPanel(new GreyHppFilter3Panel(main), getText());
            }
        });

        processMenu.add(new RunMenuItem("ThresholdFilter3Panel") {
            public void run() {
                main.addPanel(new ThresholdFilter3Panel(main), getText());
            }
        });
        processMenu.add(new RunMenuItem("ThresholdPanel") {
            public void run() {
                main.addPanel(new ThresholdPanel(main), getText());
            }
        });
        //
        processMenu.add(new RunMenuItem("salt and pepper 1000") {
            public void run() {
                Image img = main.getImage();
                ShortImageBean sib = new ShortImageBean(img);
                sib.saltAndPepper(1000);
                main.setImage(sib.getImage());
            }
        });

    }

    private static RunMenu getDrawMenu(Main main) {
        RunMenu rm = new RunMenu("[Draw");
        rm.add(new RunMenuItem("start draw program") {
            public void run() {
                DrawComponent.main(null);
            }
        });
        return rm;
    }

    public static RunMenu getRobinsonMenu(final Main main) {
        RunMenu rm = new RunMenu("Robinson");

        rm.add(new RunMenuItem("Robinson1") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getRobinson1());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Robinson2") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getRobinson2());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Robinson3") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getRobinson3());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Robinson4") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getRobinson4());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Robinson5") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getRobinson5());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Robinson6") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getRobinson6());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Robinson7") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getRobinson7());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Robinson8") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getRobinson8());
                main.setImage(img);
            }
        });
        return rm;
    }

    public static RunMenu getLaplacianMenu(final Main main) {
        RunMenu rm = new RunMenu("Laplacian");
        rm.add(new RunMenuItem("L3") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getLaplacian3());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("L5") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getLaplacian5());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("L9") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getLaplacian9());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("L-Prewitt") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getLaplacianPrewitt());
                main.setImage(img);
            }
        });

        return rm;
    }

    public static RunMenu getHpMenu(final Main main) {
        RunMenu rm = new RunMenu("Hp");
        rm.add(new RunMenuItem("Hp1") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getHp1());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Hp2") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getHp2());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Hp3") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getHp3());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Hp4") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getHp4());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Hp5") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getHp5());
                main.setImage(img);
            }
        });

        return rm;
    }

    public static RunMenu getLpMenu(final Main main) {
        RunMenu rm = new RunMenu("Lp");
        rm.add(new RunMenuItem("Lp1") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getLp1());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Lp2") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getLp2());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Lp3") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getLp3());
                main.setImage(img);
            }
        });

        return rm;
    }

    public static RunMenu getOtherTransformsMenu(final Main main) {
        RunMenu rm = new RunMenu("Other Filters");
        rm.add(new RunMenuItem("Average 3x3") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getAverage3x3());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Gabor 7") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getGabor7());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Hat 13") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getHat13());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Mean 3") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getMean3());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Mean 9") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getMean9());
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Sobel") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, Kernels.getSobel());
                main.setImage(img);
            }
        });

        return rm;
    }

    public static float[][] shortMatrixToFloat(short sm[][]) {
        float[][] fm = new float[sm.length][sm[0].length];

        for (int x = 0; x < sm.length; x++) {
            for (int y = 0; y < sm[x].length; y++) {
                fm[x][y] = sm[x][y];
            }
        }
        return fm;
    }

    public static RunMenu getMedianMenu(final Main main) {
        RunMenu rm = new RunMenu("Median Filters");
        rm.add(new RunMenuItem("Median 1x2") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, shortMatrixToFloat(Kernels.getMedian1x2()));
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Median 2x1") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, shortMatrixToFloat(Kernels.getMedian2x1()));
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Median Cross 3x3") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, shortMatrixToFloat(Kernels.getMedianCross3x3()));
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Median Cross 5x5") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, shortMatrixToFloat(Kernels.getMedianCross5x5()));
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Median Cross 7x7") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, shortMatrixToFloat(Kernels.getMedianCross7x7()));
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Median Diamond") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, shortMatrixToFloat(Kernels.getMedianDiamond()));
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Median Octagon 5x5") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, shortMatrixToFloat(Kernels.getMedianOctagon5x5()));
                main.setImage(img);
            }
        });
        rm.add(new RunMenuItem("Median Square 7x7") {
            public void run() {
                Image img = main.getImage();
                img = ImageUtils.convolution(img, shortMatrixToFloat(Kernels.getMedianSquare7x7()));
                main.setImage(img);
            }
        });


        return rm;
    }



}
