package j2d.gui;

import gui.run.RunMenu;
import gui.run.RunMenuItem;

import javax.swing.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 21, 2005
 * <p/>
 * Time: 9:30:02 AM
 */
public class FileMenu {
    public static void addFileMenu(final Main main, JMenuBar mb) {
        RunMenu fileMenu = new RunMenu("[File");
        mb.add(fileMenu);

        fileMenu.add(new RunMenuItem("[Open{ctrl O}",
                Hex.getOpenIcon()) {
            public void run() {
                main.openImage();
            }
        });

        fileMenu.add(new RunMenuItem("[Capture screen{alt 4}",
                Hex.getCaptureIcon()) {
            public void run() {
                main.captureScreen();
            }
        });
        fileMenu.add(new RunMenuItem("View Continuous Camera Stream",
                Hex.getCaptureIcon()) {
            public void run() {
                main.captureVideo();
            }
        });
        fileMenu.add(new RunMenuItem("Camera snap",
                Hex.getCaptureIcon()) {
            public void run() {
                main.usbSnap();
            }
        });
        fileMenu.add(new RunMenuItem("Camera close",
                Hex.getCaptureIcon()) {
            public void run() {
                main.closePlayer();
            }
        });
        fileMenu.add(new RunMenuItem("[Revert{ctrl W}",
                Hex.getRevertIcon()) {
            public void run() {
                main.revertImage();
            }
        });
        fileMenu.add(new RunMenuItem("[Save{ctrl S}",
                Hex.getSaveIcon()) {
            public void run() {
                main.saveImage();
            }
        });
        fileMenu.add(new RunMenuItem("[Print Hex{ctrl h}") {
            public void run() {
                main.printHexImage();
            }
        });

        fileMenu.add(new RunMenuItem("E[xit{ctrl Q}",
                Hex.getExitIcon()) {
            public void run() {
                main.shutdown();
            }
        });
    }
}
