/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.gui;

import gui.ClosableJFrame;
import gui.run.Matrix3dView;
import gui.run.RunColor3dPanel;
import gui.run.RunMenu;
import gui.run.RunMenuItem;
import ip.color.*;
import j2d.ShortImageBean;
import j2d.color.ColorSafe;
import j2d.color.ColorizerPanel;
import j2d.color.FloatColorConverterInterface;
import j2d.color.quantization.*;
import j2d.hpp.InvertFilter;

import javax.vecmath.Matrix3d;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 21, 2005
 * <p/>
 * Time: 9:30:40 AM
 */
public class ColorMenu {


    public static RunMenu getColorQuantizationMenu(final Main main) {
        RunMenu rm = new RunMenu("[quantization");
        rm.add(new RunMenuItem("ColorSafeQuant") {
            public void run() {
                main.process(new ColorSafe());
            }
        });
        rm.add(new RunMenuItem("linearCut") {
            public void run() {
                main.addPanel(new LinearCutPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("median cut") {
            public void run() {
                main.addPanel(new MedianCutPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("wu") {
            public void run() {
                main.addPanel(new WuPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("octree") {
            public void run() {
                main.addPanel(new OctreePanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("print number of colors") {
            public void run() {
                Image image = main.getImage();
                ColorFrame cf = new ColorFrame();
                cf.setImage(image);
                cf.printNumberOfColors();
                main.setImage(cf.getImage());
            }
        });
        rm.add(new RunMenuItem("nuQuant256") {
            public void run() {
                Image image = main.getImage();
                ColorFrame cf = new ColorFrame();
                cf.setImage(image);
                cf.nuQuant();
                main.setImage(cf.getImage());
            }
        });
        return rm;
    }

    public static RunMenu getColorVisualizationMenu(final Main main) {
        RunMenu rm = new RunMenu("java3d");
        rm.add(new RunMenuItem("showColors") {
            public void run() {
                visualizeFloatingImageBean(main.getFloatImage(), main.getImage());
            }
        });
        return rm;
    }

    //todo implement a color visualization of the floatImageBean
    private static void visualizeFloatingImageBean(FloatImageBean fib, Image img) {
        // Get all the unique colors in the floatImage
        // build a scenegraph and display it.
        // make a new sphere for each color
        // The location of the sphere will be based in the floatImage coordinates
        // The color of the sphere will be in the rgb coordinates.
        ColorHash ch = new ColorHash(img);
        Color c[] = ch.getColors();
        for (int i = 0; i < c.length; i++) {
            Color sphereColor = c[i];
            float sphereCoordinates[] = new float[3];
            Color.RGBtoHSB(sphereColor.getRed(),
                    sphereColor.getGreen(),
                    sphereColor.getBlue(),
                    sphereCoordinates);
            // add the spheres here.
        }
    }


    public static RunMenu getColorMenu(final Main main) {
        RunMenu rm = new RunMenu("[Color");
        rm.add(getColorVisualizationMenu(main));
        rm.add(getColorQuantizationMenu(main));
        rm.add(getColorConversions(main));
        rm.add(new RunMenuItem("Pse[udoColorFilter") {
            public void run() {
                main.addPanel(new ColorizerPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("gray") {
            public void run() {
                Image img = main.getImage();
                ShortImageBean sib = new ShortImageBean(img);
                sib.gray();
                main.setImage(sib.getImage());
            }
        });
        rm.add(new RunMenuItem("[negate{ctrl C}") {
            public void run() {
                main.process(new InvertFilter());
            }
        });

        rm.add(new RunMenuItem("show color panel (buggy?)") {
            public void run() {
                showColorPanel(main);

            }
        });
        //Yuv
        return rm;
    }

    private static RunMenu getColorConversions(final Main main) {
        RunMenu rm = new RunMenu("[conversions");
        rm.add(new RunMenuItem("rgb2iyq") {
            public void run() {
                main.process(new FloatColorConverterInterface(Yiq.getRgb2yiqMat()));
            }
        });
        rm.add(new RunMenuItem("iyq2rgb") {
            public void run() {
                main.process(new FloatColorConverterInterface(Yiq.getYiq2rgbMat()));
            }
        });
        rm.add(new RunMenuItem("CcirYuv2Rgb") {
            public void run() {
                main.process(new FloatColorConverterInterface(Ccir601_2cbcr.getCycbcr2rgbMat()));
            }
        });
        rm.add(new RunMenuItem("Rgb2CcirYuv") {
            public void run() {
                main.process(new FloatColorConverterInterface(Ccir601_2cbcr.getRgb2cycbcrMat()));
            }
        });
        rm.add(new RunMenuItem("rgb2Xyzd65") {
            public void run() {
                main.process(new FloatColorConverterInterface(Xyzd65.getRgb2xyzMat()));
            }
        });
        rm.add(new RunMenuItem("Xyzd652rgb") {
            public void run() {
                main.process(new FloatColorConverterInterface(Xyzd65.getXyz2rgbMat()));
            }
        });
        rm.add(new RunMenuItem("rgb2yuv") {
            public void run() {
                main.process(new FloatColorConverterInterface(Yuv.getRgb2yuvMat()));
            }
        });
        rm.add(new RunMenuItem("yuv2rgb") {
            public void run() {
                main.process(new FloatColorConverterInterface(Yuv.getYuv2rgbMat()));
            }
        });
        return rm;
    }

    // todo: debug this showColorPanel
    private static void showColorPanel(final Main main) {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        final Matrix3dView view = new Matrix3dView();
        c.add(new RunColor3dPanel() {
            public void run() {
                Matrix3d value = getValue();
                //System.out.println(value);
                view.updateView(value);
                main.process(new FloatColorConverterInterface(value));
            }
        });

        c.add(view);
        c.setLayout(new FlowLayout());
        cf.setSize(400, 400);
        cf.setVisible(true);
    }

}
