// InvertFilter.java
// InvertFilter is an ImageFilter that inverts a
// BufferedImage's RGB color values.
package j2d.filters;

// Java core packages

import ip.transforms.BufferedImageProcessor;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;

public class InvertFilter implements BufferedImageProcessor {

    // apply color inversion filter to BufferedImage
    public BufferedImage process(BufferedImage image) {
        // create 256 color array and invert colors
        byte[] invertArray = new byte[256];

        for (int counter = 0; counter < 256; counter++)
            invertArray[counter] = (byte) (255 - counter);

        // create filter to invert colors
        BufferedImageOp invertFilter = new LookupOp(
                new ByteLookupTable(0, invertArray), null);

        // apply filter to displayImage
        return invertFilter.filter(image, null);

    } // end method processImage
}


