/*
 * Created by IntelliJ IDEA.
 * User: lyon
 * Date: Aug 2, 2002
 * Time: 8:34:50 AM
 */
package j2d.edge.gabor;

import java.util.Observable;

public class GaborParams extends Observable {
    // sample defaults
    //lambda=16.0 theta=0.8726646259971648
    //phi=0.0 gamma=0.5 sigma=8.994750006205322
    private double sigma = 6;
    private double lambda = sigma / 2;
    private double theta = 1;
    private double phi = 0;
    private double gamma = 0.5;


    public String toString() {
        return
                "lambda=" + lambda +
                " theta=" + theta +
                " phi=" + phi +
                " gamma=" + gamma +
                " sigma=" + sigma;
    }

    public double getLambda() {
        return lambda;
    }

    public void setLambda(double _lambda) {
        this.lambda = _lambda;
        super.setChanged();
        super.notifyObservers();
    }

    public double getTheta() {
        return theta;
    }

    public void setTheta(double _theta) {
        this.theta = _theta;
        super.setChanged();
        super.notifyObservers();
    }

    public double getPhi() {
        return phi;
    }

    public void setPhi(double _phi) {
        this.phi = _phi;
        super.setChanged();
        super.notifyObservers();
    }

    public double getGamma_val() {
        return gamma;
    }

    public void setGamma(double _gamma) {
        this.gamma = _gamma;
        super.setChanged();
        super.notifyObservers();
    }

    public double getSigma() {
        return sigma;
    }

    public void setSigma(double _sigma) {
        this.sigma = _sigma;
        lambda = sigma / 2;
        super.setChanged();
        super.notifyObservers();
    }
}
