package j2d.edge;

import gui.run.RunButton;
import gui.run.RunSlider;
import j2d.*;
import j2d.animation.AnimationDialog;

import javax.swing.*;
import java.awt.*;


public class LoGPanel extends JPanel {


    private int kernelWidth = 19;
    private double sigma = 2.0;

    ImageProcessListener ipl = null;

    /**Construct the frame*/
    public LoGPanel(ImageProcessListener _ipl) {
        ipl = _ipl;
        initGuiElements();

    }

    /**Component initialization*/
    private void initGuiElements() {
        setLayout(new FlowLayout());

        add(new RunButton("apply") {
            public void run() {
                updateImage();
            }
        });
        add(new RunButton("Reset") {
            public void run() {
                ipl.update(null);
            }
        });
        add(new JLabel("kernel width"));
        add(new RunSlider(4, 19, 19) {
            public void run() {
                kernelWidth = getValue();
                updateImage();
            }
        });
        add(new RunButton("comparison") {
            public void run() {
                ImageProcessorFactory ipf =
                        new LoGProcessor(
                                kernelWidth,
                                sigma);
                ComparisonUtils.showComparisonFrame(
                        getComparisonPanel(ipf));
            }
        });
        AnimationProcessor ap = new AnimationProcessor();
        add(ap.getButton());
    }

    public JPanel getComparisonPanel(ImageProcessorFactory ipf) {

        ImageBeanInterface origImagePanel = (ImageBeanInterface) ipl;
        Image sourceImage = origImagePanel.getImage();
        return ComparisonUtils.getComparisonPanel(sourceImage, ipf);

    }

    public void updateImage() {
        try {
            ipl.update(new LoGProcessor(
                    kernelWidth,
                    sigma
            ));
        } catch (Exception e) {
            System.out.println("ER!:kernelWidth=" + kernelWidth);
        }
    }

    class AnimationProcessor
            extends LoGProcessor {
        public RunButton getButton() {
            return
                    new RunButton("save Gifs") {
                        public void run() {
                            saveGifs();
                        }
                    };
        }

        AnimationProcessor() {
            super(kernelWidth,
                    sigma);
        }

        public ImageProcessorInterface getProcessor(int i) {
            return
                    new LoGProcessor(
                            kernelWidth,
                            i);
        }

        public void saveGifs() {
            ImageBeanInterface origImagePanel =
                    (ImageBeanInterface) ipl;
            new AnimationDialog(origImagePanel.getImage(),
                    this);
        }
    }

}
