// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3)
// Source File Name:   EdgeDetector.java

package j2d.edge;

import j2d.ImageProcessorInterface;
import j2d.ImageProcessorFactory;

import java.awt.*;


public class CannyProcessor
        implements ImageProcessorInterface,
        ImageProcessorFactory {

    private int imagePels[];
    private int derivativeOfMag[];
    private int magnitude[];
    private int orientation[];

    private int tLow = 50;
    private int tHi = 230;
    private int threshold = 128;
    private int widGaussianKernel = 15;
    private float sigma = 1.0f;

    public CannyProcessor(int thresh1,
                          int thresh2,
                          int thresh,
                          int kw,
                          float sigma) {
        tLow = thresh1;
        tHi = thresh2;
        threshold = thresh;
        widGaussianKernel = kw;
        this.sigma = sigma;
    }

    public ImageProcessorInterface getProcessor(int i) {
        return new CannyProcessor(tLow, tHi, threshold,
                widGaussianKernel, i);
    }

    public Image process(Image _sourceImage) {
        Image sourceImage = _sourceImage;
        if (threshold < 0 || threshold > 255)
            futils.Out.messageDialog("The value of the threshold is out of its valid range.");
        if (widGaussianKernel < 3 || widGaussianKernel > 40)
            futils.Out.messageDialog("The value of the widGaussianKernel is out of its valid range.");
        int width = sourceImage.getWidth(null);
        int height = sourceImage.getHeight(null);
        int picsize = width * height;
        imagePels = new int[picsize];
        magnitude = new int[picsize];
        orientation = new int[picsize];

        cannyCore(width, height, sourceImage, sigma, widGaussianKernel);
        edgeDetect(width, height);
        for (int i = 0; i < picsize; i++)
            if (imagePels[i] > threshold)
                imagePels[i] = 0xff000000;
            else
                imagePels[i] = -1;

        return j2d.ImageUtils.getImage(
                imagePels, width, height);
    }

    private void cannyCore(int width,
                           int height,
                           Image sourceImage,
                           float sigma,
                           int i) {
        boolean flag = false;
        boolean flag1 = false;
        int picsize = width * height;
        derivativeOfMag = new int[picsize];
        float af4[] = new float[i];
        float af3[] = new float[i];
        float af6[] = new float[i];
        imagePels = j2d.ImageUtils.getPels(sourceImage);
        int k4 = 0;
        do {
            if (k4 >= i)
                break;
            float f1 = gaussian(k4, sigma);
            if (f1 <= 0.005F && k4 >= 2)
                break;
            float f2 = gaussian((float) k4 - 0.5F, sigma);
            float f3 = gaussian((float) k4 + 0.5F, sigma);
            float f4 = gaussian(k4, sigma * 0.5F);
            af4[k4] = (f1 + f2 + f3) / 3F / (6.283185F * sigma * sigma);
            af3[k4] = f3 - f2;
            af6[k4] = 1.6F * f4 - f1;
            k4++;
        } while (true);
        int j = k4;
        float af[] = new float[picsize];
        float af1[] = new float[picsize];
        int j1 = width - (j - 1);
        int l = width * (j - 1);
        int i1 = width * (height - (j - 1));
        for (int l4 = j - 1; l4 < j1; l4++) {
            for (int l5 = l; l5 < i1; l5 += width) {
                int k1 = l4 + l5;
                float f8 = (float) imagePels[k1] * af4[0];
                float f10 = f8;
                int l6 = 1;
                int k7 = k1 - width;
                for (int i8 = k1 + width; l6 < j; i8 += width) {
                    f8 += af4[l6] * (float) (imagePels[k7] + imagePels[i8]);
                    f10 += af4[l6] * (float) (imagePels[k1 - l6] + imagePels[k1 + l6]);
                    l6++;
                    k7 -= width;
                }

                af[k1] = f8;
                af1[k1] = f10;
            }

        }

        float[] af2 = getAf2(picsize, j, j1, l, i1, af3, af, width);

        af = null;
        af3 = getAf3(picsize, k4, width, l, i1, j, af3, af1);

        af1 = null;
        j1 = width - j;
        l = width * j;
        i1 = width * (height - j);
        for (int k5 = j; k5 < j1; k5++) {
            for (int k6 = l; k6 < i1; k6 += width) {
                int j2 = k5 + k6;
                int k2 = j2 - width;
                int l2 = j2 + width;
                int i3 = j2 - 1;
                int j3 = j2 + 1;
                int k3 = k2 - 1;
                int l3 = k2 + 1;
                int i4 = l2 - 1;
                int j4 = l2 + 1;
                float f6 = af2[j2];
                float f7 = af3[j2];
                float f12 = hypotenuse(f6, f7);
                int k = (int) ((double) f12 * 20D);
                derivativeOfMag[j2] = k >= 256 ? 255 : k;
                float f13 = hypotenuse(af2[k2], af3[k2]);
                float f14 = hypotenuse(af2[l2], af3[l2]);
                float f15 = hypotenuse(af2[i3], af3[i3]);
                float f16 = hypotenuse(af2[j3], af3[j3]);
                float f18 = hypotenuse(af2[l3], af3[l3]);
                float f20 = hypotenuse(af2[j4], af3[j4]);
                float f19 = hypotenuse(af2[i4], af3[i4]);
                float f17 = hypotenuse(af2[k3], af3[k3]);
                float f5;
                if (f6 * f7 <= (float) 0 ? Math.abs(f6) >= Math.abs(f7) ? (f5 = Math.abs(f6 * f12)) >= Math.abs(f7 * f18 - (f6 + f7) * f16) && f5 > Math.abs(f7 * f19 - (f6 + f7) * f15) : (f5 = Math.abs(f7 * f12)) >= Math.abs(f6 * f18 - (f7 + f6) * f13) && f5 > Math.abs(f6 * f19 - (f7 + f6) * f14) : Math.abs(f6) >= Math.abs(f7) ? (f5 = Math.abs(f6 * f12)) >= Math.abs(f7 * f20 + (f6 - f7) * f16) && f5 > Math.abs(f7 * f17 + (f6 - f7) * f15) : (f5 = Math.abs(f7 * f12)) >= Math.abs(f6 * f20 + (f7 - f6) * f14) && f5 > Math.abs(f6 * f17 + (f7 - f6) * f13)) {
                    magnitude[j2] = derivativeOfMag[j2];
                    orientation[j2] = (int) (
                            Math.atan2(f7, f6) * (double) 40F);
                }
            }

        }

        derivativeOfMag = null;
        af2 = null;
        af3 = null;
    }

    private float[] getAf3(int picsize, int k4, int width, int l, int i1, int j, float[] af5, float[] af1) {
        float af3[] = new float[picsize];
        for (int j5 = k4; j5 < width - k4; j5++) {
            for (int j6 = l; j6 < i1; j6 += width) {
                float f11 = 0.0F;
                int i2 = j5 + j6;
                int j7 = 1;
                for (int l7 = width; j7 < j; l7 += width) {
                    f11 += af5[j7] * (af1[i2 - l7] - af1[i2 + l7]);
                    j7++;
                }

                af3[i2] = f11;
            }

        }
        return af3;
    }

    private float[] getAf2(int picsize, int j, int j1, int l, int i1, float[] af5, float[] af, int width) {
        float af2[] = new float[picsize];
        for (int i5 = j - 1; i5 < j1; i5++) {
            for (int i6 = l; i6 < i1; i6 += width) {
                float f9 = 0.0F;
                int l1 = i5 + i6;
                for (int i7 = 1; i7 < j; i7++)
                    f9 += af5[i7] * (af[l1 - i7] - af[l1 + i7]);

                af2[l1] = f9;
            }

        }
        return af2;
    }

    private float hypotenuse(float f, float f1) {
        if (f == 0.0F && f1 == 0.0F)
            return 0.0F;
        else
            return (float) Math.sqrt(f * f + f1 * f1);
    }

    private float gaussian(float f, float sigma) {
        return (float) Math.exp((-f * f) / ((float) 2 * sigma * sigma));
    }

    private void edgeDetect(int width, int height) {
        int picsize = width * height;
        imagePels = new int[picsize];

        for (int x = 0; x < width; x++) {
            for (int y = 0; y < height; y++)
                if (magnitude[x + width * y] >= tLow)
                    followEdge(width, height, x, y);

        }

    }

    private boolean followEdge(int width, int height, int x, int y) {
        int j1 = x + 1;
        int k1 = x - 1;
        int l1 = y + 1;
        int i2 = y - 1;
        int j2 = x + y * width;
        if (l1 >= height)
            l1 = height - 1;
        if (i2 < 0)
            i2 = 0;
        if (j1 >= width)
            j1 = width - 1;
        if (k1 < 0)
            k1 = 0;
        if (imagePels[j2] == 0) {
            imagePels[j2] = magnitude[j2];
            boolean flag = false;
            int l = k1;
            do {
                if (l > j1)
                    break;
                int i1 = i2;
                do {
                    if (i1 > l1)
                        break;
                    int k2 = l + i1 * width;
                    if ((i1 != y || l != x) && magnitude[k2] >= tHi &&
                            followEdge(width, height, l, i1)) {
                        flag = true;
                        break;
                    }
                    i1++;
                } while (true);
                if (!flag)
                    break;
                l++;
            } while (true);
            return true;
        } else {
            return false;
        }
    }


}
