package j2d.color.quantization;

import gui.ImageBeanInterface;
import ip.color.ColorHash;
import ip.color.FloatImageBean;
import ip.color.MedianCut;
import ip.color.Wu;
import j2d.ImageBean;
import j2d.ImageProcessListener;
import j2d.ShortImageBean;
import utils.Print;
import video.jsnap.NqController;

import java.awt.*;

public class ColorFrame {
    private ColorHash ch = null;

    double[] matrix3d = new double[9];
    public ShortImageBean shortImageBean =
            new ShortImageBean();

    private ImageBeanInterface ib = new ImageBean();

    public ColorFrame() {

    }

    private String noFloatMsg = "Make a float image first, use rgbtoxxx";
    private FloatImageBean fp = null;

    public void setShortImageBean(ShortImageBean sib) {
        shortImageBean = sib;
        ib.setImage(shortImageBean);

    }


    public void setImage(Image i) {
        ib.setImage(i);
        image2Short();

    }

    public void image2Short() {
        if (getImage() == null) return;
        Image img = ib.getImage();
        shortImageBean = new j2d.ShortImageBean(img);
    }


    public Image getImage() {
        return ib.getImage();
    }


    public void yuv2rgb() {
        if (fp == null) {
            Print.println(noFloatMsg);
            return;
        }
        fp.toRgb();
        fp.updateParent();
    }

    public void iyq2rgb() {
        if (fp == null) {
            Print.println(noFloatMsg);
            return;
        }
        fp.toRgb();
        fp.updateParent();
    }

    public void hsb2rgb() {
        if (fp == null) {
            Print.println(noFloatMsg);
            return;
        }
        fp.toRgb();
        fp.updateParent();
    }

    public void xyzd652rgb() {
        if (fp == null) {
            System.out.println(noFloatMsg);
            return;
        }
        fp.toRgb();
        fp.updateParent();
    }


    public void ccir601_2cbcr2rgb() {
        if (fp == null) {
            Print.println(noFloatMsg);
            return;
        }
        fp.toRgb();
        fp.updateParent();
    }


    //The followig methods are for the Quantization method
    public void printNumberOfColors() {
        Print.println("Computing Colors");
        Print.println("There are " +
                computeNumberOfColors() +
                " colors in this image");
    }

    public int computeNumberOfColors() {
        ch = new ColorHash();
        ch.addShortArrays(shortImageBean.getR(),
                shortImageBean.getG(),
                shortImageBean.getB());
        return ch.countColors();
    }

    public void linearCut(int sr, int sg, int sb) {
        ShortImageBean.linearCut(shortImageBean.getR(), sr);
        ShortImageBean.linearCut(shortImageBean.getG(), sg);
        ShortImageBean.linearCut(shortImageBean.getB(), sb);
        short2Image();
    }

    public void short2Image() {
        ib.setImage(shortImageBean);

    }

    public void medianCut(int k) {
        MedianCut mc = new MedianCut(shortImageBean.getPels(),
                ib.getImageWidth(),
                ib.getImageHeight());
        setImage(mc.convert(k));
    }

    public void wu(int k) {
        Wu rewu = new Wu();
        rewu.wuQuantization(shortImageBean,
                k);
        short2Image();
    }

    public void octree(int numberOfColors) {
        ip.color.Octree ot = new ip.color.Octree();
        ot.octreeQuantization(shortImageBean.getR(),
                shortImageBean.getG(),
                shortImageBean.getB(), numberOfColors);
        swapGreenAndBlue(this);
    }

    public static void swapGreenAndBlue(ColorFrame colorFrame) {
        ShortImageBean sib = colorFrame.shortImageBean;
        short temp[][] = sib.getG();
        colorFrame.setG(sib.getB());
        colorFrame.setB(temp);
        colorFrame.short2Image();
    }

    public void nuQuant() {
        setImage(NqController.colorReduce(ib.getImage()));

    }

    public void setB(short r[][]) {
        shortImageBean.setB(r);
    }

    public void setG(short r[][]) {
        shortImageBean.setG(r);
    }

    public ShortImageBean getShortImageBean() {
        return shortImageBean;
    }


}



