/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color;

import ip.color.FloatImageBean;
import j2d.FloatImageProcessorInterface;
import j2d.ImageProcessorInterface;
import math.Mat3;

import javax.vecmath.Matrix3d;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 21, 2005
 * <p/>
 * Time: 9:04:21 AM
 */
public class FloatColorConverterInterface implements FloatImageProcessorInterface{

    private Mat3 m;

    public FloatColorConverterInterface(Mat3 m){
        this.m = m;
    }
    public FloatColorConverterInterface(Matrix3d m3d) {
        m = new Mat3(m3d);
    }
    public FloatImageBean process(FloatImageBean fib){
        FloatImageBean newFib = new FloatImageBean(fib.getWidth(),fib.getHeight());
        float pel[];
        for (int x = 0; x < fib.getWidth(); x++)
            for (int y = 0; y < fib.getHeight(); y++) {
                pel = m.multiply(fib.r[x][y], fib.g[x][y], fib.b[x][y]);

                newFib.r[x][y] = pel[0];
                newFib.g[x][y] = pel[1];
                newFib.b[x][y] = pel[2];
            }
        return newFib;
    }

    public Image process(Image image) {
        FloatImageBean fib = new FloatImageBean(image);
        return process(fib).getImage();
    }
}
