package j2d.border;

import gui.run.RunComboBox;
import gui.run.RunSpinnerSlider;
import javax.swing.*;
import javax.swing.event.ChangeEvent;
import java.awt.*;
import java.awt.event.ActionEvent;
import j2d.ImageProcessListener;
import j2d.gui.Main;

import javax.swing.*;
import java.awt.*;

/**
 * This class demonstrates the use of the border operator. The user can
 * interactively choose the image border dimensions and the border type.
 */

public class BorderPanel extends
        JPanel {

    // A JComboBox for the existing border types.
    private RunComboBox borderTypes;

    ImageProcessListener ipl = null;
    Main fm = null;

    // JSpinners for the four border dimensions.
    private RunSpinnerSlider top, left, right, bottom;



   /**
     * The constructor for the class, which sets its GUI.
     *
     * @param _ipl is the interface for Image processing.
     */

    public BorderPanel(ImageProcessListener _ipl) {
          ipl = _ipl;
          fm =(Main) ipl; //added in order to get methods and fields of FinalMain
          initGuiElements();
    }
    public void initGuiElements() {

        // Create a control panel for the combo box and spinners.
        JPanel controlPanel = new JPanel(new GridLayout(5, 2));
        JPanel labels = new JPanel (new GridLayout(5,2));

        labels.add(new JLabel("BorderFrame Type "));

        //add the comboBox to the controlPanel
       controlPanel.add(getComboBox());

        // Add the four sides spinners. We need four instances of SpinnerModel...
        top = new RunSpinnerSlider(new SpinnerNumberModel(0, -100, 100, 5)) {
            public void run() {
                resetImage();
            }
        };
        labels.add(new JLabel("Top border"));
        controlPanel.add(top);
        bottom = new RunSpinnerSlider(new SpinnerNumberModel(0, -100, 100, 5)) {
            public void run() {
                resetImage();
            }
        };
        labels.add(new JLabel("Bottom border"));
        controlPanel.add(bottom);
        left = new RunSpinnerSlider(new SpinnerNumberModel(0, -100, 100, 5)) {
            public void run() {
                resetImage();
            }
        };
        labels.add(new JLabel("Left border"));
        controlPanel.add(left);
        right = new RunSpinnerSlider(new SpinnerNumberModel(0, -100, 100, 5)) {
            public void run() {
                resetImage();
            }
        };

       labels.add(new JLabel("Right border"));
        controlPanel.add(right);




        setLayout(new BorderLayout());
         add(controlPanel, BorderLayout.CENTER);
        add(labels, BorderLayout.WEST);

    }
     //border type combo box.
    private RunComboBox getComboBox() {
        borderTypes = new RunComboBox(new String[]{"Zero",
                                                   "Constant",
                                                   "Copy",
                                                   "Reflection",
                                                   "Wrap"}) {
            public void run() {
                resetImage();
            }
        };
         return borderTypes;
    }


    /**
     * This method will be called when the spinners' contents change.
     */
    public void stateChanged(ChangeEvent e) {
        resetImage();
    }

    /**
     * This method will be called when the combo box contents change.
     */
    public void actionPerformed(ActionEvent e) {
        resetImage();
    }

    /**
     * This method will create a border around the image with the values
     * from the spinners and combo box. The new image will be used for
     * displaying.
     */
    private void resetImage() {
        // Gets values from the spinners and combo box.
        int topValue = top.getValue();
        int bottomValue = bottom.getValue();
        int leftValue = left.getValue();
        int rightValue = right.getValue();
        int borderType = borderTypes.getSelectedIndex();
 
        ipl.update(new BorderProcessor(
                       topValue,
                       bottomValue,
                       leftValue,
                       rightValue,
                       borderType
               ));



    }



}