package j2d;

import javax.media.*;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Apr 13, 2005
 * Time: 5:10:33 PM
 * Copyright DocJava, 2005
 */
public class CameraUtils {
    // CameraUtils.getImageFromCamera
    public static BufferedImage getImageFromCamera()
            throws IOException, NoPlayerException, CannotRealizeException,
            InterruptedException {
        // Create capture device

        Player player = getPlayer();
        BufferedImage imageFromCamera = getImageFromCamera(player);
        close(player);
        return imageFromCamera;

    }

    public static Player getPlayer() throws IOException, NoPlayerException, CannotRealizeException, InterruptedException {
        CaptureDeviceInfo deviceInfo = CaptureDeviceManager.getDevice("vfw:Microsoft WDM Image Capture (Win32):0");
        Player player = Manager.createRealizedPlayer(deviceInfo.getLocator());
        player.start();

        // Wait a few seconds for camera to initialise (otherwise img==null)
        Thread.sleep(2500);
        return player;
    }

    public static BufferedImage getImageFromCamera(Player player) {
        // Grab a frame from the capture device
        FrameGrabbingControl frameGrabber = (FrameGrabbingControl)
                player.getControl("javax.media.control.FrameGrabbingControl");
        Buffer buf = frameGrabber.grabFrame();

        // Convert frame to an buffered image so it can be processed and saved
        Image img = (new BufferToImage((VideoFormat) buf.getFormat()).createImage(buf));
        BufferedImage buffImg = new BufferedImage(img.getWidth(null), img.getHeight(null),
                BufferedImage.TYPE_INT_RGB);
        Graphics2D g = buffImg.createGraphics();
        g.drawImage(img, null, null);

        // Overlay curent time on image
        g.setColor(Color.RED);
        g.setFont(new Font("Verdana", Font.BOLD, 16));
        g.drawString((new Date()).toString(), 10, 25);

        // Save image to disk as PNG
        return buffImg;
    }

    public static void close(Player player) {
        // Stop using webcam
        player.close();
        player.deallocate();
    }
}
