package ip.transforms;


import java.awt.*;
import java.util.Enumeration;
import java.util.Vector;


public class Points {
    private Vector pointVector = new Vector();
    private Enumeration pointEnumeration = null;

    public void addPoint(Point p) {
        pointVector.addElement(p);
    }

    public Point getPointAt(int i) {
        return (Point) pointVector.elementAt(i);
    }

    public boolean hasMorePoints() {
        if (pointEnumeration == null) pointEnumeration = getEnumeration();
        return pointEnumeration.hasMoreElements();
    }

    public Point nextPoint() {
        if (pointEnumeration == null) pointEnumeration = getEnumeration();
        if (!hasMorePoints()) return null;
        return (Point) pointEnumeration.nextElement();
    }

    private Enumeration getEnumeration() {
        return pointVector.elements();
    }

    public int getSize() {
        return pointVector.size();
    }

    public void drawUserPoints(Graphics g) {
        for (int i = 0; i < getSize(); i++) {
            Point p = getPointAt(i);
            g.drawLine(p.x - 1, p.y - 1, p.x + 1, p.y + 1);
            g.drawLine(p.x + 1, p.y - 1, p.x - 1, p.y + 1);
        }
    }

    public static boolean isRangeValid(Point p1, Point p2, Dimension d) {
        return isRangeValid(p1, d) && isRangeValid(p2, d);
    }

    public static boolean isRangeValid(Point p, Dimension d) {
        return (p.x >= 0) && (p.y >= 0) && (p.x < d.width) && (p.y < d.height);
    }


}



